/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.service.CommentService;
import com.atlassian.confluence.content.service.comment.EditCommentCommand;
import com.atlassian.confluence.core.actions.ServiceBackedActionHelper;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractPreviewPageAction;
import com.atlassian.confluence.pages.actions.AddCommentAction;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class EditCommentAction
extends AbstractPreviewPageAction
implements CaptchaAware {
    private CommentService commentService;
    private CaptchaManager captchaManager;
    private NotificationManager notificationManager;
    private long commentId;
    private boolean watchPageAfterComment;
    private String cleanedWysiwygContent;

    @Override
    public void validate() {
        if (!this.getEditCommentCommand().isValid()) {
            new ServiceBackedActionHelper(this.getEditCommentCommand()).addValidationErrors(this);
        }
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String doDefault() throws Exception {
        return "input";
    }

    public String doEdit() throws Exception {
        this.updateXHtmlContent();
        this.getEditCommentCommand().execute();
        if (this.watchPageAfterComment) {
            this.notificationManager.addContentNotification(this.getAuthenticatedUser(), this.getPage());
        }
        return "success";
    }

    @Deprecated(since="8.8.0", forRemoval=true)
    public Comment getComment() {
        return this.getEditCommentCommand().getComment();
    }

    public long getEditCommentId() {
        return this.getEditCommentCommand().getComment().getId();
    }

    @Override
    public String getWysiwygContent() throws XhtmlException {
        if (this.wysiwygContent == null) {
            Comment comment = this.getComment();
            this.wysiwygContent = comment == null ? "" : this.getEditorFormattedContent(this.formatConverter.cleanStorageFormat(comment.getBodyAsString()));
            this.cleanedWysiwygContent = this.wysiwygContent;
        }
        if (!this.wysiwygContent.equals(this.cleanedWysiwygContent)) {
            this.cleanedWysiwygContent = this.formatConverter.cleanEditorFormat(this.wysiwygContent, this.getRenderContext());
        }
        return this.cleanedWysiwygContent;
    }

    @Override
    public boolean isPermitted() {
        return this.getEditCommentCommand().isAuthorized();
    }

    public long getCommentId() {
        return this.commentId;
    }

    @StrutsParameter
    public void setCommentId(long commentId) {
        this.commentId = commentId;
    }

    @Override
    public List<Page> getPermittedChildren() {
        return super.getPermittedChildren();
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @StrutsParameter
    public void setWatchPageAfterComment(boolean watchPageAfterComment) {
        this.watchPageAfterComment = watchPageAfterComment;
    }

    private EditCommentCommand getEditCommentCommand() {
        return this.commentService.newEditCommentFromEditorCommand(this.getCommentId(), this.wysiwygContent);
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }

    public WebInterfaceContext getWebInterfaceContext(Comment comment) {
        return AddCommentAction.createWebInterfaceContextWithComment(super.getWebInterfaceContext(), comment);
    }
}

