/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.event.Evented;
import com.atlassian.confluence.event.events.content.page.PageListViewEvent;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.pages.actions.AbstractPaginatedListAction;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

@AnonymousSiteAccess
public class ListUndefinedPagesAction
extends AbstractPaginatedListAction<UndefinedPage>
implements Evented<PageListViewEvent> {
    private PageManagerInternal pageManager;
    private PaginationService paginationService;

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        return super.execute();
    }

    public void setApiPaginationService(PaginationService paginationService) {
        this.paginationService = paginationService;
    }

    public void setPageManager(PageManagerInternal pageManager) {
        this.pageManager = pageManager;
    }

    public List getUndefinedPages() {
        return this.paginationSupport.getItems();
    }

    @Override
    public PageListViewEvent getEventToPublish(String result) {
        return new PageListViewEvent(this, this.getSpace(), "undefined");
    }

    @Override
    public List getItems() {
        return Collections.emptyList();
    }

    private PageResponse<UndefinedPage> fetchBatch(LimitedRequest limitedRequest) {
        List<OutgoingLink> undefinedLinks = this.pageManager.getUndefinedLinks(this.key, limitedRequest);
        HashMap<String, UndefinedPage> condensedLinks = new HashMap<String, UndefinedPage>();
        for (OutgoingLink outgoingLink : undefinedLinks) {
            String destinationPageTitle = outgoingLink.getDestinationPageTitle();
            String mapKey = (outgoingLink.getDestinationSpaceKey() + ":" + destinationPageTitle).toLowerCase();
            UndefinedPage undefPage = condensedLinks.computeIfAbsent(mapKey, k -> new UndefinedPage(outgoingLink.getDestinationSpaceKey(), outgoingLink.getDestinationPageTitle()));
            undefPage.addReferenceFrom(outgoingLink);
        }
        ArrayList undefLinks = new ArrayList(condensedLinks.values());
        undefLinks.sort(null);
        PageResponseImpl response = PageResponseImpl.builder().addAll(undefLinks).pageRequest(limitedRequest).hasMore(undefinedLinks.size() >= limitedRequest.getLimit()).build();
        return response;
    }

    public PageResponse<UndefinedPage> getPageResponse() {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((int)this.paginationSupport.getStartIndex(), (int)ITEMS_PER_PAGE, (int)ITEMS_PER_PAGE, (boolean)true);
        PageResponse pagingResult = this.paginationService.performPaginationRequest(limitedRequest, nextRequest -> this.fetchBatch(limitedRequest), undefinedPage -> undefinedPage);
        return pagingResult;
    }

    public int getMaxReferencesPerUndefinedPage() {
        return 5;
    }

    @Override
    public boolean isSupportPaginationService() {
        return true;
    }

    @Override
    public long getItemsCount() {
        return this.pageManager.getUndefinedLinksCount(this.key);
    }

    public static class UndefinedPage
    implements Comparable<UndefinedPage> {
        public static final int MAX_REFERENCES = 5;
        private final String destinationSpaceKey;
        private final String destinationPageTitle;
        private final LinkedHashSet<ContentEntityObject> referencedFrom = new LinkedHashSet();
        private int numReferences = 0;

        public UndefinedPage(String spaceKey, String pageTitle) {
            this.destinationSpaceKey = spaceKey;
            this.destinationPageTitle = pageTitle;
        }

        public String getDestinationSpaceKey() {
            return this.destinationSpaceKey;
        }

        public String getDestinationPageTitle() {
            return this.destinationPageTitle;
        }

        public void addReferenceFrom(OutgoingLink link) {
            boolean isNewReference = true;
            if (this.numReferences < 5) {
                isNewReference = this.referencedFrom.add(link.getSourceContent());
            }
            if (isNewReference) {
                ++this.numReferences;
            }
        }

        public List<ContentEntityObject> getReferencedFrom() {
            return List.copyOf(this.referencedFrom);
        }

        public int getNumReferences() {
            return this.numReferences;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UndefinedPage that = (UndefinedPage)o;
            if (this.destinationPageTitle != null ? !this.destinationPageTitle.equals(that.destinationPageTitle) : that.destinationPageTitle != null) {
                return false;
            }
            return !(this.destinationSpaceKey != null ? !this.destinationSpaceKey.equals(that.destinationSpaceKey) : that.destinationSpaceKey != null);
        }

        public int hashCode() {
            int result = this.destinationSpaceKey != null ? this.destinationSpaceKey.hashCode() : 0;
            result = 29 * result + (this.destinationPageTitle != null ? this.destinationPageTitle.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(UndefinedPage other) {
            int i = this.destinationPageTitle.compareTo(other.destinationPageTitle);
            return i == 0 ? this.destinationSpaceKey.compareTo(other.destinationSpaceKey) : i;
        }
    }
}

