/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.content.service.page.MovePageCommandHelper;
import com.atlassian.confluence.content.service.page.PageLocator;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.pages.actions.AbstractCommandAction;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
@ReadOnlyAccessBlocked
public class MovePageAction
extends AbstractCommandAction {
    private PageService pageService;
    private SpaceService spaceService;
    private MovePageCommandHelper movePageCommandHelper;
    private long pageId;
    private long targetId;
    private String position;
    private String spaceKey;
    private String targetTitle;
    private String mode = MovePageCommandHelper.MovePageMode.ASYNC.name();

    @Override
    protected ServiceCommand createCommand() {
        PageLocator sourcePageLocator = this.pageService.getIdPageLocator(this.pageId);
        if ("topLevel".equals(this.position)) {
            assert (this.spaceKey != null);
            return this.movePageCommandHelper.newMovePageCommand(sourcePageLocator, this.spaceService.getKeySpaceLocator(this.spaceKey), MovePageCommandHelper.MovePageMode.valueOf(this.mode));
        }
        PageLocator targetPageLocator = this.targetId != 0L ? this.pageService.getIdPageLocator(this.targetId) : this.pageService.getTitleAndSpaceKeyPageLocator(this.spaceKey, this.targetTitle);
        return this.movePageCommandHelper.newMovePageCommand(sourcePageLocator, targetPageLocator, this.position, MovePageCommandHelper.MovePageMode.valueOf(this.mode));
    }

    @StrutsParameter
    public void setTargetId(long targetId) {
        this.targetId = targetId;
    }

    @StrutsParameter
    public void setTargetTitle(String targetTitle) {
        this.targetTitle = targetTitle;
    }

    @StrutsParameter
    public void setPosition(String position) {
        this.position = position;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    @StrutsParameter
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    @StrutsParameter
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public void setMovePageCommandHelper(MovePageCommandHelper movePageCommandHelper) {
        this.movePageCommandHelper = movePageCommandHelper;
    }

    @StrutsParameter
    public void setMode(String mode) {
        this.mode = mode;
    }
}

