/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AuthenticationHelper;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@UnrestrictedAccess
public class PageNotPermittedAction
extends ConfluenceActionSupport
implements PageAware {
    private static final Logger log = LoggerFactory.getLogger(PageNotPermittedAction.class);
    private static final String REQUEST_ACCESS_PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-request-access-plugin";
    @VisibleForTesting
    static final String NO_SPACE_PERMISSION_REDIRECT_RESULT = "noSpaceEditPermission";
    @VisibleForTesting
    static final String NO_EDIT_PERMISSION_REDIRECT_RESULT = "noEditPermission";
    @VisibleForTesting
    static final String REQUEST_EDIT_ACCESS_URL_PARAMETER = "requestEditAccess";
    @VisibleForTesting
    static final String SPACE_EDITING_RESTRICTION_URL_PARAMETER = "spaceEditingRestriction";
    @VisibleForTesting
    static final String CREATE_PAGE_ACTION = "/pages/createpage.action";
    @VisibleForTesting
    static final String CREATE_BLOG_POST_ACTION = "/pages/createblogpost.action";
    @VisibleForTesting
    static final String EDIT_PAGE_ACTION = "/pages/editpage.action";
    @VisibleForTesting
    static final String EDIT_BLOG_POST_ACTION = "/pages/editblogpost.action";
    private static final Set<String> EDIT_ACTIONS = ImmutableSet.of((Object)"/pages/createpage.action", (Object)"/pages/createblogpost.action", (Object)"/pages/editpage.action", (Object)"/pages/editblogpost.action");
    private long pageId;
    private long draftId;
    private String spaceKey;
    private String title;
    private PageManager pageManager;
    private AbstractPage page;
    private ContentPermissionManager contentPermissionManager;

    @PermittedMethods(value={HttpMethod.ANY_METHOD})
    @XsrfProtectionExcluded
    public String execute() {
        boolean targetObjectIsDraft = this.getTargetObject().map(ContentEntityObject::isDraft).orElse(false);
        if (this.getAuthenticatedUser() == null) {
            return "login";
        }
        if (!targetObjectIsDraft) {
            if (this.isRequestToCreateOrEditPage() && this.userCanViewButNotEditSpace() && this.userCanViewPage()) {
                return NO_SPACE_PERMISSION_REDIRECT_RESULT;
            }
            if (this.isRequestToCreateOrEditPage() && this.userCanViewButNotEditPage()) {
                return NO_EDIT_PERMISSION_REDIRECT_RESULT;
            }
        }
        return "success";
    }

    public String getNoPageEditPermissionRedirectUrl() {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)(this.page != null ? this.page.getUrlPath() : this.getTargetUrlPath()));
        if (!this.accessModeService.isReadOnlyAccessModeEnabled()) {
            uriBuilder.queryParam(REQUEST_EDIT_ACCESS_URL_PARAMETER, new Object[]{"true"});
        }
        return uriBuilder.build().toString();
    }

    public String getNoSpaceEditPermissionRedirectUrl() {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)(this.page != null ? this.page.getUrlPath() : this.getTargetUrlPath()));
        if (!this.accessModeService.isReadOnlyAccessModeEnabled()) {
            uriBuilder.queryParam(SPACE_EDITING_RESTRICTION_URL_PARAMETER, new Object[]{"true"});
        }
        return uriBuilder.build().toString();
    }

    public long getPageId() {
        return this.pageId;
    }

    public long getDraftId() {
        return this.draftId;
    }

    @StrutsParameter
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    @StrutsParameter
    public void setDraftId(long draftId) {
        this.draftId = draftId;
    }

    @Override
    public AbstractPage getPage() {
        return this.page;
    }

    @Override
    public void setPage(AbstractPage page) {
        this.page = page;
    }

    @Override
    public boolean isPageRequired() {
        return false;
    }

    @Override
    public boolean isLatestVersionRequired() {
        return false;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return false;
    }

    public boolean canUserRequestAccessOnCurrentPage() {
        if (this.page == null) {
            return false;
        }
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        boolean result = false;
        if (this.page.hasPermissions("Edit")) {
            boolean bl = result = !this.contentPermissionManager.hasContentLevelPermission(currentUser, "Edit", this.page);
        }
        if (this.page.hasPermissions("View")) {
            result = result || !this.contentPermissionManager.hasContentLevelPermission(currentUser, "View", this.page);
        }
        return result;
    }

    public String getLoginUrl() {
        return AuthenticationHelper.getLoginUrl();
    }

    public boolean isRequestAccessPluginEnabled() {
        return this.pluginAccessor.isPluginEnabled(REQUEST_ACCESS_PLUGIN_KEY);
    }

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    @StrutsParameter
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getTitle() {
        return this.title;
    }

    @StrutsParameter
    public void setTitle(String pageTitle) {
        this.title = pageTitle;
    }

    private boolean isRequestToCreateOrEditPage() {
        return EDIT_ACTIONS.contains(this.getActiveRequest().getServletPath());
    }

    private boolean userCanViewButNotEditSpace() {
        Optional<AbstractPage> targetObject = this.getTargetObject();
        Optional<Space> targetSpace = targetObject.map(SpaceContentEntityObject::getSpace);
        boolean isAPage = targetObject.map(page -> page instanceof Page).orElse(false);
        boolean isABlogPost = targetObject.map(page -> page instanceof BlogPost).orElse(false);
        return targetSpace.map(space -> this.spacePermissionManager.hasPermission("VIEWSPACE", (Space)space, this.getAuthenticatedUser()) && (isAPage && !this.spacePermissionManager.hasPermission("EDITSPACE", (Space)space, this.getAuthenticatedUser()) || isABlogPost && !this.spacePermissionManager.hasPermission("EDITBLOG", (Space)space, this.getAuthenticatedUser()))).orElse(false);
    }

    private boolean userCanViewPage() {
        Optional<AbstractPage> targetPage = this.getTargetObject();
        return targetPage.map(page -> this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.VIEW, page)).orElse(false);
    }

    private boolean userCanViewButNotEditPage() {
        Optional<AbstractPage> targetPage = this.getTargetObject();
        return targetPage.map(page -> this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.VIEW, page) && !this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.EDIT, page)).orElse(false);
    }

    private Optional<AbstractPage> getTargetObject() {
        AbstractPage draft;
        if (this.page != null) {
            return Optional.of(this.page.getLatestVersion());
        }
        if (this.draftId != 0L && (draft = this.pageManager.getAbstractPage(this.draftId)) != null) {
            return Optional.of(draft.getLatestVersion());
        }
        return Optional.empty();
    }

    public String getTargetUrlPath() {
        return this.getTargetObject().map(AddressablePage::of).map(AddressablePage::getUrlPath).orElse("");
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }
}

