/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.actions.AbstractRemoveAttachmentAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
public class RemoveAttachedFileVersionAction
extends AbstractRemoveAttachmentAction {
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        return "success";
    }

    public String doRemove() {
        Attachment attachment = this.getAttachment();
        this.attachmentManager.removeAttachmentVersionFromServer(attachment);
        return "success";
    }

    @Override
    protected String localiseActionName(String actionI18NKey) {
        return super.localiseActionName("remove.attachment.version.confirmation.title");
    }

    @StrutsParameter
    public void setVersion(int version) {
        this.attachmentBean.setVersion(version);
    }

    @Override
    public int getVersion() {
        return this.attachmentBean.getVersion();
    }

    @Override
    public boolean isPermitted() {
        Space space = this.getSpace();
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            return false;
        }
        if (space == null) {
            return false;
        }
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, space);
    }
}

