/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.pages.actions.ActionHelper;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.Permission;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class RemovePagePermissionAction
extends AbstractPageAwareAction {
    private long permissionId;
    private boolean removeAll;
    private String returnPath;

    @StrutsParameter
    public void setPermissionId(long permissionId) {
        this.permissionId = permissionId;
    }

    @StrutsParameter
    public void setRemoveAll(boolean removeAll) {
        this.removeAll = removeAll;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    @StrutsParameter
    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String execute() {
        if (this.removeAll) {
            this.contentPermissionManager.setContentPermissions((Map<String, Collection<ContentPermission>>)ImmutableMap.of((Object)"View", (Object)Collections.EMPTY_LIST, (Object)"Edit", (Object)Collections.EMPTY_LIST), this.getPage());
        } else {
            ContentPermission permission = this.getPermissionFromPage(this.getPage(), this.permissionId);
            if (permission != null) {
                this.contentPermissionManager.removeContentPermission(permission);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.returnPath)) {
            return "returnPath";
        }
        return "success";
    }

    private ContentPermission getPermissionFromPage(AbstractPage page, long permissionId) {
        for (ContentPermission o : page.getPermissions()) {
            ContentPermission permission = o;
            if (permission.getId() != permissionId) continue;
            return permission;
        }
        return null;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return false;
    }

    @Override
    public boolean isPermitted() {
        return this.isSpaceAdmin() || this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.SET_PERMISSIONS, this.getPage()) && this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.EDIT, this.getPage());
    }

    private boolean isSpaceAdmin() {
        return ActionHelper.isSpaceAdmin(this.getSpace(), this.getAuthenticatedUser(), this.spacePermissionManager);
    }
}

