/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.pages.actions.AbstractCommandAction;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.xsrf.XsrfProtectionRequired;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class SetPageOrderAction
extends AbstractCommandAction {
    private PageService pageService;
    private long pageId;
    private String orderedChildIds;

    @Override
    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionRequired
    public String execute() {
        return super.execute();
    }

    @Override
    protected ServiceCommand createCommand() {
        String[] idStrs = this.orderedChildIds.split(",");
        ArrayList<Long> childIds = new ArrayList<Long>(idStrs.length);
        for (String idStr : idStrs) {
            if (!StringUtils.isNotBlank((CharSequence)idStr)) continue;
            childIds.add(Long.parseLong(idStr));
        }
        return this.pageService.newSetPageOrderCommand(this.pageService.getIdPageLocator(this.pageId), childIds);
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    @StrutsParameter
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    @StrutsParameter
    public void setOrderedChildIds(String orderedChildIds) {
        this.orderedChildIds = orderedChildIds;
    }
}

