/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.security.Permission;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class TinyUrlAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(TinyUrlAction.class);
    private PageManager pageManager;
    private String urlPath;
    private String urlIdentifier;
    private static final String NOT_FOUND = "pagenotfound";

    @StrutsParameter
    public void setUrlIdentifier(String urlIdentifier) {
        this.urlIdentifier = urlIdentifier;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws IOException {
        if (StringUtils.isBlank((CharSequence)this.urlIdentifier)) {
            return NOT_FOUND;
        }
        try {
            TinyUrl url = new TinyUrl(this.urlIdentifier);
            AbstractPage page = this.pageManager.getAbstractPage(url.getPageId());
            if (page == null) {
                return NOT_FOUND;
            }
            this.urlPath = this.getUrlPath(page);
            return "success";
        }
        catch (Exception e) {
            log.error("Unable to retrieve page from TinyUrl: {}", (Object)e.getMessage(), (Object)e);
            return "error";
        }
    }

    private String getUrlPath(AbstractPage page) {
        if (this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.VIEW, page)) {
            return page.getUrlPath();
        }
        return "/pages/viewpage.action?pageId=" + page.getId();
    }

    public String getUrlPath() {
        return this.urlPath;
    }
}

