/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.Evented;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.analytics.HttpRequestStats;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.impl.pages.readtime.EstimatedReadTimeService;
import com.atlassian.confluence.languages.LocaleInfo;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.pages.actions.CommentAware;
import com.atlassian.confluence.pages.actions.ViewPageActionPathConverter;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConversionAction;
import com.atlassian.confluence.setup.settings.CollaborativeEditingHelper;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.struts.flash.FlashScope;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.renderer.links.Link;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import io.atlassian.fugue.Pair;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class ViewPageAction
extends AbstractPageAction
implements CommentAware,
Evented<ConfluenceEvent> {
    private static final Logger log = LoggerFactory.getLogger(ViewPageAction.class);
    public static final String REQUEST_KEY_HELPER = "view.page.action.helper";
    protected static final String DARKFEATUE_CONFLUENCE_PAGE_READTIME = "confluence.page.readtime";
    protected static final String DARK_FEATURE_CONFLUENCE_READABLE_URL = "confluence.readable.url";
    protected NotificationManager notificationManager;
    protected CommentManager commentManager;
    private ThemeManager themeManager;
    private CollaborativeEditingHelper collaborativeEditingHelper;
    protected Renderer editRenderer;
    private XhtmlContent xhtmlContent;
    private List externalReferences;
    private Map<Comment, String> xHtmlComments;
    private String pageXHtmlContent;
    private long replyToComment;
    private boolean showCommentArea = false;
    private boolean editComment = false;
    private boolean navigatingVersions;
    private String editingUser;
    private DarkFeaturesManager darkFeaturesManager;
    private EstimatedReadTimeService estimatedReadTimeService;
    private int readTimeInMins = 1;
    private String forwardLocation;
    private String redirectLocation;
    private Comment comment;
    private Pair<PathConversionAction, String> redirectOrForwardRequestAction;
    private ViewPageActionPathConverter viewPageActionPathConverter;

    @Override
    @Deprecated(since="8.8.0", forRemoval=true)
    public Comment getComment() {
        return this.comment;
    }

    public long getCommentId() {
        return this.comment.getId();
    }

    @Override
    public void setComment(Comment comment) {
        this.comment = comment;
    }

    @Deprecated(since="8.8.0", forRemoval=true)
    public Page getParentPage() {
        AbstractPage abstractPage = this.getPage();
        if (abstractPage instanceof Page) {
            Page page = (Page)abstractPage;
            return page.getParent();
        }
        return null;
    }

    public List getExternalReferences() {
        return this.externalReferences;
    }

    @Override
    public boolean isPageRequired() {
        return true;
    }

    @Override
    public boolean isLatestVersionRequired() {
        return false;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return true;
    }

    @Internal
    public String getEditingUser() {
        return this.editingUser;
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionExcluded
    public String execute() throws Exception {
        Optional<String> forwardOrRedirectResult;
        if (this.darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled(DARK_FEATURE_CONFLUENCE_READABLE_URL) && (forwardOrRedirectResult = this.doForwardOrRedirect()).isPresent()) {
            return forwardOrRedirectResult.get();
        }
        User user = (User)FlashScope.get("editingUser");
        if (user != null) {
            this.editingUser = user.getFullName();
        }
        if (this.pageIsLatestVersionAndDoesNotHaveSpace()) {
            this.addActionError("error.corrupt.page", "" + this.getPage().getId(), this.getPage().getBodyContent().getBody());
            return "error";
        }
        AbstractPage page = this.xhtmlContent.convertWikiBodyToStorage(this.getPage());
        if (this.darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled(DARKFEATUE_CONFLUENCE_PAGE_READTIME)) {
            this.readTimeInMins = this.estimatedReadTimeService.getReadTime(page.getBodyAsString());
        }
        ServletContextThreadLocal.getRequest().setAttribute(REQUEST_KEY_HELPER, (Object)this.getHelper());
        HttpRequestStats.elapse("viewPageRenderingStarted");
        this.pageXHtmlContent = this.viewRenderer.render(page);
        HttpRequestStats.elapse("viewPageRenderingFinished");
        AbstractPage contentEntityObject = this.getPage();
        this.externalReferences = new PageContext(contentEntityObject).getExternalReferences();
        this.addToHistory(this.getPage());
        ServletContextThreadLocal.getRequest().setAttribute("defer.js.opt.in", (Object)true);
        return this.getPage().getType();
    }

    protected boolean pageIsLatestVersionAndDoesNotHaveSpace() {
        return this.getPage() != null && this.getPage().getSpace() == null && this.getPage().isLatestVersion();
    }

    @Override
    public ConfluenceEvent getEventToPublish(String result) {
        LocaleInfo localeInfo = this.localeManager.getLocaleInfo(AuthenticatedUserThreadLocal.get());
        if (this.getPage() instanceof Page) {
            return new PageViewEvent((Object)this, (Page)this.getPage(), localeInfo);
        }
        if (this.getPage() instanceof BlogPost) {
            return new BlogPostViewEvent((Object)this, (BlogPost)this.getPage(), localeInfo);
        }
        return null;
    }

    @HtmlSafe
    public String getPageXHtmlContent() {
        return this.pageXHtmlContent;
    }

    @HtmlSafe
    public Map<Comment, String> getXHtmlComments() {
        if (this.xHtmlComments == null) {
            this.xHtmlComments = new HashMap<Comment, String>();
            for (Comment comment : this.getPage().getComments()) {
                this.xHtmlComments.put(comment, this.viewRenderer.render(comment));
            }
        }
        return this.xHtmlComments;
    }

    public Boolean getChildrenShowing() {
        return this.getUserInterfaceState().getChildrenShowing();
    }

    @StrutsParameter
    public void setShowChildren(Boolean showChildren) {
        this.getUserInterfaceState().setChildrenShowing(showChildren);
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public boolean isThreadComments() {
        return this.getGlobalSettings().isAllowThreadedComments();
    }

    public boolean isUserWatchingPage() {
        if (this.isAnonymousUser() || this.getPage() == null) {
            return false;
        }
        try {
            return this.notificationManager.isWatchingContent(this.getAuthenticatedUser(), this.getPage());
        }
        catch (Exception e) {
            log.error("Error finding if user is watching page", (Throwable)e);
            return false;
        }
    }

    public boolean isUserWatchingSpace() {
        if (this.isAnonymousUser() || this.getPage() == null) {
            return false;
        }
        ContentTypeEnum typeEnum = ContentTypeEnum.getByRepresentation(this.getPage().getType());
        return this.notificationManager.getNotificationByUserAndSpaceAndType(this.getAuthenticatedUser(), this.getSpace(), typeEnum) != null;
    }

    public String getDateString(Date date) {
        return this.getDateFormatter().formatDateFull(date);
    }

    public String renderExternalLink(Link link) {
        String linkBody;
        String extLink = linkBody = link.getLinkBody();
        if (!linkBody.contains("<")) {
            extLink = GeneralUtil.displayShortUrl(linkBody);
        }
        return "<a href=\"" + link.getUrl() + "\" title=\"" + link.getTitle() + "\">" + extLink + "</a>";
    }

    public long getReplyToComment() {
        return this.replyToComment;
    }

    @StrutsParameter
    public void setReplyToComment(long replyToComment) {
        this.replyToComment = replyToComment;
    }

    public List<ContentPermission> getInheritedContentPermissions() {
        return this.contentPermissionManager.getInheritedContentPermissionSets(this.getPage()).stream().flatMap(set -> StreamSupport.stream(set.spliterator(), false)).collect(Collectors.toList());
    }

    public List<ContentPermission> getThisPagePermissions() {
        return this.getPage().getPermissions();
    }

    public long getPageIdOfVersionBefore(AbstractPage page) {
        ContentEntityObject entity = this.pageManager.getPreviousVersion(page);
        return entity == null ? -1L : entity.getId();
    }

    public long getPageIdOfVersionAfter(AbstractPage page) {
        ContentEntityObject entity = this.pageManager.getNextVersion(page);
        return entity == null ? -1L : entity.getId();
    }

    public boolean hasPreviousVersion(AbstractPage page) {
        try {
            return this.getPageIdOfVersionBefore(page) > 0L;
        }
        catch (Exception e) {
            log.error("Error retrieving version of page previous to: {}", (Object)page, (Object)e);
            return false;
        }
    }

    public boolean hasNextVersion(AbstractPage page) {
        try {
            return this.getPageIdOfVersionAfter(page) > 0L;
        }
        catch (Exception e) {
            log.error("Error retrieving version of page after: {}", (Object)page, (Object)e);
            return false;
        }
    }

    public boolean isShowCommentArea() {
        return this.showCommentArea;
    }

    @StrutsParameter
    public void setShowCommentArea(boolean showCommentArea) {
        this.showCommentArea = showCommentArea;
    }

    public boolean isEditComment() {
        return this.editComment;
    }

    @StrutsParameter
    public void setEditComment(boolean editComment) {
        this.editComment = editComment;
    }

    public boolean isNavigatingVersions() {
        return this.navigatingVersions;
    }

    @StrutsParameter
    public void setNavigatingVersions(boolean navigatingVersions) {
        this.navigatingVersions = navigatingVersions;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    @HtmlSafe
    public String getCommentAsXHtmlForWysiwyg() {
        return this.editRenderer.render(this.getComment());
    }

    @Override
    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = DefaultWebInterfaceContext.copyOf(super.getWebInterfaceContext());
        result.withLazyParameter("labels", () -> this.getPage() == null ? Collections.emptyList() : this.getPage().getLabelsForDisplay(this.getAuthenticatedUser()));
        result.withLazyParameter("parentPage", this::getParentPage);
        if (this.getClass().equals(ViewPageAction.class)) {
            result.setParameter("viewMode", Boolean.TRUE);
        }
        return result;
    }

    public WebInterfaceContext getWebInterfaceContext(Comment comment) {
        DefaultWebInterfaceContext result = DefaultWebInterfaceContext.copyOf(this.getWebInterfaceContext());
        result.setComment(comment);
        return result;
    }

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.VIEW, this.getPage());
    }

    public List getViewInheritedContentPermissionSets() {
        return this.contentPermissionManager.getContentPermissionSets(((Page)this.getPage()).getParent(), "View");
    }

    public boolean hasAnyPermissions() {
        return this.getPage().hasContentPermissions() || !this.getInheritedContentPermissions().isEmpty();
    }

    public void setEditRenderer(Renderer editRenderer) {
        this.editRenderer = editRenderer;
    }

    public void setXhtmlContent(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public boolean isChildrenNotShown() {
        Theme spaceTheme = this.themeManager.getSpaceTheme(this.getSpaceKey());
        return spaceTheme.hasSpaceSideBar();
    }

    @ExperimentalApi
    public void setCollaborativeEditingHelper(CollaborativeEditingHelper collaborativeEditingHelper) {
        this.collaborativeEditingHelper = collaborativeEditingHelper;
    }

    @ExperimentalApi
    public CollaborativeEditingHelper getCollaborativeEditingHelper() {
        return this.collaborativeEditingHelper;
    }

    public void setDarkFeaturesManager(DarkFeaturesManager darkFeaturesManager) {
        this.darkFeaturesManager = darkFeaturesManager;
    }

    public void setEstimatedReadTimeService(EstimatedReadTimeService estimatedReadTimeService) {
        this.estimatedReadTimeService = estimatedReadTimeService;
    }

    public int getReadTime() {
        return this.readTimeInMins;
    }

    public String getForwardLocation() {
        return this.forwardLocation;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    private Optional<String> doForwardOrRedirect() {
        Pair<PathConversionAction, String> action = this.getRedirectOrForwardRequestAction();
        String forwardOrRedirectResult = null;
        if (action != null) {
            String nextPath = (String)action.right();
            PathConversionAction pathConversionAction = (PathConversionAction)((Object)action.left());
            switch (pathConversionAction) {
                case FORWARD: {
                    this.forwardLocation = nextPath;
                    forwardOrRedirectResult = "forward";
                    break;
                }
                case REDIRECT: {
                    this.redirectLocation = nextPath;
                    forwardOrRedirectResult = "redirect";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown PathConversionAction: " + String.valueOf((Object)pathConversionAction));
                }
            }
        }
        return Optional.ofNullable(forwardOrRedirectResult);
    }

    private Pair<PathConversionAction, String> getRedirectOrForwardRequestAction() {
        if (this.redirectOrForwardRequestAction == null) {
            ConvertedPath convertedPath;
            String result;
            String queryString;
            HttpServletRequest request = ServletContextThreadLocal.getRequest();
            String servletPath = ServletContextThreadLocal.getRequest().getServletPath();
            String pathName = servletPath.substring(servletPath.lastIndexOf(47) + 1);
            if (this.viewPageActionPathConverter.handles(pathName, queryString = request.getQueryString()) && StringUtils.isNotBlank((CharSequence)(result = (convertedPath = this.viewPageActionPathConverter.getPath(pathName, queryString)).getPath()))) {
                this.redirectOrForwardRequestAction = Pair.pair((Object)((Object)convertedPath.getAction()), (Object)result);
            }
        }
        return this.redirectOrForwardRequestAction;
    }

    public void setViewPageActionPathConverter(ViewPageActionPathConverter viewPageActionPathConverter) {
        this.viewPageActionPathConverter = viewPageActionPathConverter;
    }
}

