/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConversionAction;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.QueryStringUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Map;
import java.util.Optional;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ViewPageActionPathConverter
implements PathConverter {
    private static final ConvertedPath NO_REDIRECT = new ConvertedPath("");
    private final PageManager pageManager;
    private final PermissionManager permissionManager;

    public ViewPageActionPathConverter(PageManager pageManager, PermissionManager permissionManager) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean handles(String pathInfo, String queryString) {
        return "viewpage.action".equals(pathInfo);
    }

    @Override
    public ConvertedPath getPath(String pathInfo, String queryString) {
        AbstractPage page;
        AbstractPage abstractPage = page = queryString != null ? this.getPageFromQueryString(queryString) : null;
        if (page == null || page.getSpace() == null) {
            return NO_REDIRECT;
        }
        Map<String, String> queryParams = QueryStringUtil.toMap(queryString, StandardCharsets.UTF_8);
        queryParams.remove("pageId");
        String spaceKey = queryParams.remove("spaceKey");
        String title = queryParams.remove("title");
        String noRedirectParam = queryParams.remove("noRedirect");
        boolean noRedirect = Optional.ofNullable(noRedirectParam).map(Boolean::parseBoolean).orElse(false);
        if (page instanceof BlogPost) {
            queryParams.remove("postingDay");
            queryParams.remove("month");
            queryParams.remove("day");
            queryParams.remove("year");
        }
        Space space = page.getSpace();
        String generatedTitleSlug = AddressablePage.of(page).generateTitleSlug();
        if (!page.isLatestVersion() || queryParams.containsKey("flashId") || noRedirect || (space.getKey().equalsIgnoreCase(spaceKey) || HtmlUtil.urlEncode(space.getKey(), StandardCharsets.UTF_8).equalsIgnoreCase(spaceKey)) && generatedTitleSlug.equals(AddressablePage.generateTitleSlug(title)) || !ViewPageActionPathConverter.isSafeToRedirectAndRevealPageId(this.permissionManager, page) || generatedTitleSlug.isEmpty()) {
            return NO_REDIRECT;
        }
        if (page.getSpace().getHomePage() != null && page.getSpace().getHomePage().getId() == page.getId()) {
            return new ConvertedPath("/spaces/" + HtmlUtil.urlEncode(space.getKey(), StandardCharsets.UTF_8) + "/overview" + ViewPageActionPathConverter.toQueryParameters(queryParams), PathConversionAction.REDIRECT, false);
        }
        boolean shouldDisplayTitle = ViewPageActionPathConverter.hasPagePermission(this.permissionManager, page);
        return new ConvertedPath(AddressablePage.of(page).getUrlPath(shouldDisplayTitle) + ViewPageActionPathConverter.toQueryParameters(queryParams), PathConversionAction.REDIRECT, false);
    }

    private static String toQueryParameters(Map<String, String> queryParams) {
        return queryParams.isEmpty() ? "" : "?" + QueryStringUtil.toString(queryParams, StandardCharsets.UTF_8);
    }

    private @Nullable AbstractPage getPageFromQueryString(String queryString) {
        String spaceKey = null;
        String title = null;
        String postingDay = null;
        int pageVersion = 0;
        long pageId = 0L;
        for (NameValuePair pair : URLEncodedUtils.parse((CharSequence)queryString, (Charset)StandardCharsets.UTF_8)) {
            if ("pageId".equals(pair.getName())) {
                try {
                    pageId = Long.parseLong(pair.getValue());
                }
                catch (NumberFormatException ex) {
                    pageId = 0L;
                }
            }
            if ("spaceKey".equals(pair.getName())) {
                spaceKey = pair.getValue();
            }
            if ("title".equals(pair.getName())) {
                title = pair.getValue();
            }
            if ("postingDay".equals(pair.getName())) {
                postingDay = pair.getValue();
            }
            if (!"pageVersion".equals(pair.getName())) continue;
            pageVersion = Integer.parseInt(pair.getValue());
        }
        return this.getPageFromQueryParameters(pageId, spaceKey, title, postingDay, pageVersion);
    }

    private @Nullable AbstractPage getPageFromQueryParameters(long pageId, String spaceKey, String title, String postingDay, Integer pageVersion) {
        if (pageVersion != 0) {
            AbstractPage page = this.pageManager.getAbstractPage(pageId);
            return this.pageManager.getPageByVersion(page, pageVersion);
        }
        if (pageId != 0L) {
            return this.pageManager.getAbstractPage(pageId);
        }
        if (spaceKey == null || title == null) {
            return null;
        }
        if (postingDay != null) {
            Calendar posted = BlogPost.getCalendarFromDatePath(postingDay);
            return posted != null ? this.pageManager.getBlogPost(spaceKey, title, posted) : this.pageManager.getPage(spaceKey, title);
        }
        return this.pageManager.getPage(spaceKey, title);
    }

    private static boolean isNotDraft(AbstractPage page) {
        return page != null && !page.isDraft();
    }

    private static boolean currentUserCanEdit(AbstractPage page, PermissionManager permissionManager) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return permissionManager.hasPermission(currentUser, Permission.EDIT, page);
    }

    static boolean isSafeToRedirectAndRevealPageId(PermissionManager permissionManager, AbstractPage page) {
        return !(!page.isValidSpaceKey() || !ViewPageActionPathConverter.isNotDraft(page) && !ViewPageActionPathConverter.currentUserCanEdit(page, permissionManager) || AuthenticatedUserThreadLocal.get() == null && !permissionManager.hasPermission(null, Permission.VIEW, page));
    }

    static boolean hasPagePermission(PermissionManager permissionManager, AbstractPage page) {
        return permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, page);
    }
}

