/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.ContentCursor;
import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ContentTrashService;
import com.atlassian.confluence.event.Evented;
import com.atlassian.confluence.event.events.space.SpaceTrashViewEvent;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ViewTrashAction
extends AbstractSpaceAdminAction
implements Evented<SpaceTrashViewEvent> {
    private static final String TRASH_CONTENT_PAGE_SIZE_KEY = "space.trash.content.pagination.size.max";
    private static final Integer TRASH_CONTENT_PAGE_SIZE_MAX = Integer.getInteger("space.trash.content.pagination.size.max", 500);
    private TrashManager trashManager;
    private ContentTrashService apiContentTrashService;
    private PlatformTransactionManager transactionManager;
    private boolean isReverse;
    private long contentId;
    private int limit;

    public PageResponse<Content> getTrash() {
        LimitedRequest request = this.contentId == 0L ? LimitedRequestImpl.create((Cursor)ContentCursor.EMPTY_CURSOR, (int)(this.limit > 0 ? this.limit : TRASH_CONTENT_PAGE_SIZE_MAX), (int)TRASH_CONTENT_PAGE_SIZE_MAX) : LimitedRequestImpl.create((Cursor)ContentCursor.createCursor((boolean)this.isReverse, (long)this.contentId), (int)(this.limit > 0 ? this.limit : TRASH_CONTENT_PAGE_SIZE_MAX), (int)TRASH_CONTENT_PAGE_SIZE_MAX);
        Expansion[] expansions = ExpansionsParser.parse((String)"ancestors,container,space,metadata");
        DefaultTransactionAttribute transactionDefinition = new DefaultTransactionAttribute(3);
        TransactionTemplate template = new TransactionTemplate(this.transactionManager, (TransactionDefinition)transactionDefinition);
        template.setReadOnly(true);
        TransactionCallback callback = status -> this.apiContentTrashService.getTrashContents(Space.builder().key(this.getSpaceKey()).build(), request, expansions);
        return (PageResponse)template.execute(callback);
    }

    public void setApiContentTrashService(ContentTrashService apiContentTrashService) {
        this.apiContentTrashService = apiContentTrashService;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TrashManager getTrashManager() {
        return this.trashManager;
    }

    public void setTrashManager(TrashManager trashManager) {
        this.trashManager = trashManager;
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    @StrutsParameter
    public void setReverse(boolean isReverse) {
        this.isReverse = isReverse;
    }

    public long getContentId() {
        return this.contentId;
    }

    @StrutsParameter
    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    public int getLimit() {
        return this.limit;
    }

    @StrutsParameter
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public SpaceTrashViewEvent getEventToPublish(String result) {
        return new SpaceTrashViewEvent(this, this.getSpace());
    }
}

