/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.attachments;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.impl.content.render.prefetch.ImageDetailsPrefetchDao;
import com.atlassian.confluence.impl.content.render.prefetch.hibernate.HibernatePrefetchHelper;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.attachments.ImageDetails;
import com.atlassian.confluence.pages.attachments.ImageDetailsDao;
import com.atlassian.confluence.pages.attachments.ImageDetailsDto;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

@ParametersAreNonnullByDefault
public class DefaultImageDetailsDao
implements ImageDetailsDao,
ImageDetailsPrefetchDao {
    private final SessionFactory sessionFactory;

    public DefaultImageDetailsDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ImageDetails getImageDetails(Attachment attachment) {
        ImageDetailsDto storedDetails = (ImageDetailsDto)this.sessionFactory.getCurrentSession().get(ImageDetailsDto.class, (Serializable)Long.valueOf(DefaultImageDetailsDao.imageId(attachment)));
        if (storedDetails == null) {
            return null;
        }
        return storedDetails.toImageDetails();
    }

    @Override
    public void save(ImageDetails imageDetails) {
        this.sessionFactory.getCurrentSession().save((Object)new ImageDetailsDto(imageDetails));
    }

    @Override
    public void removeDetailsFor(Attachment attachment) {
        Session session = this.sessionFactory.getCurrentSession();
        session.createQuery("from ImageDetailsDto details where details.id = :imageId", ImageDetailsDto.class).setParameter("imageId", (Object)DefaultImageDetailsDao.imageId(attachment)).list().forEach(arg_0 -> ((Session)session).delete(arg_0));
    }

    public static long imageId(Attachment attachment) {
        return attachment.getId();
    }

    @Override
    @Internal
    public int prefetchImageDetails(Collection<Attachment> attachments) {
        Set ids = attachments.stream().map(DefaultImageDetailsDao::imageId).collect(Collectors.toSet());
        return new HibernatePrefetchHelper(this.sessionFactory.getCurrentSession()).prefetchEntitiesById("id", ids, ImageDetailsDto.class).size();
    }
}

