/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.attachments;

import com.atlassian.confluence.core.NotExportable;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.attachments.ImageDetails;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Proxy;

@Entity
@Table(name="IMAGEDETAILS")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Proxy(lazy=false)
public class ImageDetailsDto
implements NotExportable {
    @Id
    @Column(name="ATTACHMENTID", updatable=false)
    @GenericGenerator(name="foreign", strategy="foreign", parameters={@Parameter(name="property", value="attachment")})
    @GeneratedValue(generator="foreign")
    private long id;
    @OneToOne(fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @PrimaryKeyJoinColumn
    private Attachment attachment;
    @Column(name="HEIGHT")
    private int height;
    @Column(name="WIDTH")
    private int width;
    @Column(name="MIMETYPE", length=30)
    private String mimeType;

    protected ImageDetailsDto() {
    }

    ImageDetailsDto(ImageDetails imageDetails) {
        this.attachment = imageDetails.getAttachment();
        this.height = imageDetails.getHeight();
        this.width = imageDetails.getWidth();
        this.mimeType = imageDetails.getMimeType();
    }

    ImageDetails toImageDetails() {
        return new ImageDetails(this.attachment, this.width, this.height, this.mimeType);
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

