/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao.hibernate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentData;
import com.atlassian.confluence.pages.AttachmentDataNotFoundException;
import com.atlassian.confluence.pages.AttachmentDataStorageType;
import com.atlassian.confluence.pages.attachments.AttachmentDataStreamSizeMismatchException;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDataStream;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDataStreamType;
import com.atlassian.confluence.pages.persistence.dao.LegacyAttachmentDataDaoSupport;
import com.atlassian.confluence.pages.persistence.dao.TransactionalAttachmentDataDao;
import com.atlassian.confluence.web.rangerequest.RangeRequest;
import com.atlassian.core.bean.EntityObject;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CountingInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.event.spi.EventSource;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

@Deprecated(forRemoval=true, since="8.8")
public class HibernateAttachmentDataDao
extends HibernateObjectDao
implements TransactionalAttachmentDataDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateAttachmentDataDao.class);

    public @NonNull List findAll() {
        throw new UnsupportedOperationException("Retrieving all attachment data is not supported");
    }

    public @NonNull List findAllSorted(String s) {
        throw new UnsupportedOperationException("Retrieving all attachment data is not supported");
    }

    public void save(EntityObject objectToSave) {
        super.save(objectToSave);
        Session session = this.getSessionFactory().getCurrentSession();
        session.flush();
        if (objectToSave instanceof HibernateProxy || ((EventSource)session).getPersistenceContext().isEntryFor((Object)objectToSave)) {
            session.evict((Object)objectToSave);
        }
    }

    public Class getPersistentClass() {
        return AttachmentData.class;
    }

    protected AttachmentData getAttachmentDataForAttachment(Attachment attachment) throws AttachmentDataNotFoundException {
        List dataObjects = this.getSessionFactory().getCurrentSession().createNamedQuery("confluence.ad_findAttachmentDataByAttachment", AttachmentData.class).setParameter("attachment", (Object)attachment).setParameter("version", (Object)attachment.getVersion()).list();
        if (dataObjects.isEmpty()) {
            throw new AttachmentDataNotFoundException("No AttachmentData object was returned when it was expected for attachment: " + String.valueOf(attachment));
        }
        if (dataObjects.size() > 1) {
            throw new IncorrectResultSizeDataAccessException("Multiple AttachmentData objects were returned when only one was expected for attachment: " + String.valueOf(attachment), 1, dataObjects.size());
        }
        return (AttachmentData)dataObjects.get(0);
    }

    @Override
    public InputStream getDataForAttachment(Attachment attachment) throws AttachmentDataNotFoundException {
        if (attachment == null) {
            throw new IllegalArgumentException("Attachment must be non-null");
        }
        AttachmentData attachmentData = this.getAttachmentDataForAttachment(attachment);
        InputStream result = attachmentData.getData();
        this.hibernate().evict(attachmentData);
        return result;
    }

    @Override
    public void removeDataForAttachment(Attachment attachment, ContentEntityObject originalContent) {
        this.checkAttachmentAndOriginalContentArgumentsNotNull(attachment, originalContent);
        if (!attachment.isLatestVersion()) {
            throw new IllegalArgumentException("Attachment must be latest version");
        }
        try {
            for (AttachmentData attachmentData : this.getAllAttachmentData(attachment)) {
                attachmentData.setAttachment(null);
                this.remove(attachmentData);
            }
        }
        catch (AttachmentDataNotFoundException adnfe) {
            this.handleAttachmendDataNotFoundException(attachment, adnfe);
        }
    }

    @Override
    public void removeDataForAttachmentVersion(Attachment attachment, ContentEntityObject originalContent) {
        try {
            AttachmentData attachmentData = this.getAttachmentDataForAttachment(attachment);
            attachmentData.setAttachment(null);
            this.remove(attachmentData);
        }
        catch (AttachmentDataNotFoundException adnfe) {
            this.handleAttachmendDataNotFoundException(attachment, adnfe);
        }
    }

    @Override
    public void removeDataForAttachmentVersion(Attachment attachmentVersion, ContentEntityObject originalContent, AttachmentDataStreamType dataStreamType) {
        if (dataStreamType == AttachmentDataStreamType.EXTRACTED_TEXT) {
            return;
        }
        this.removeDataForAttachment(attachmentVersion, originalContent);
    }

    @Override
    public void moveDataForAttachmentVersion(Attachment sourceAttachmentVersion, Attachment targetAttachmentVersion) {
        AttachmentData sourceAttachmentData = null;
        try {
            sourceAttachmentData = this.getAttachmentDataForAttachment(sourceAttachmentVersion);
        }
        catch (AttachmentDataNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not find data for [%s], see cause.", sourceAttachmentData), e);
        }
        this.removeDataForAttachment(targetAttachmentVersion, targetAttachmentVersion.getContainer());
        sourceAttachmentData.setAttachment(targetAttachmentVersion);
        this.save(sourceAttachmentData);
    }

    private List<AttachmentData> getAllAttachmentData(Attachment latestVersion) throws AttachmentDataNotFoundException {
        if (!latestVersion.isNew()) {
            List data = this.getSessionFactory().getCurrentSession().createNamedQuery("confluence.ad_findAllHistoricalAttachmentDataByLatestAttachment", AttachmentData.class).setParameter("attachment", (Object)latestVersion).list();
            return ImmutableList.builder().addAll((Iterable)data).add((Object)this.getAttachmentDataForAttachment(latestVersion)).build();
        }
        return List.of(this.getAttachmentDataForAttachment(latestVersion));
    }

    @Override
    public void saveDataForAttachment(Attachment attachment, InputStream data) {
        AttachmentData attachmentData = new AttachmentData();
        attachmentData.setAttachment(attachment);
        attachmentData.setVersion(attachment.getVersion());
        attachmentData.setData(data);
        this.saveAttachmentData(attachmentData);
    }

    @Override
    public void saveDataForAttachmentVersion(Attachment attachment, Attachment previousVersion, InputStream data) {
        AttachmentData previousAttachmentData;
        Attachment previousAttachment = new Attachment();
        previousAttachment.setId(attachment.getId());
        previousAttachment.setVersion(previousVersion.getVersion());
        try {
            previousAttachmentData = this.getAttachmentDataForAttachment(previousAttachment);
        }
        catch (AttachmentDataNotFoundException e) {
            throw new RuntimeException("There was a problem retrieving the previous version of the Attachment data for Attachment '" + String.valueOf(previousAttachment) + "'.", e);
        }
        previousAttachmentData.setAttachment(previousVersion);
        previousAttachmentData.setVersion(previousVersion.getVersion());
        this.save(previousAttachmentData);
        AttachmentData newAttachmentData = new AttachmentData();
        newAttachmentData.setAttachment(attachment);
        newAttachmentData.setVersion(attachment.getVersion());
        newAttachmentData.setData(data);
        this.saveAttachmentData(newAttachmentData);
    }

    void saveAttachmentData(AttachmentData attachmentData) {
        CountingInputStream countingInputStream = new CountingInputStream(attachmentData.getData());
        attachmentData.setData((InputStream)countingInputStream);
        this.save(attachmentData);
        long expectedFileSize = attachmentData.getAttachment().getFileSize();
        if (countingInputStream.getCount() != expectedFileSize) {
            Session session = this.getSessionFactory().getCurrentSession();
            session.lock((Object)attachmentData, LockMode.NONE);
            session.delete((Object)attachmentData);
            session.flush();
            if (attachmentData instanceof HibernateProxy || ((EventSource)session).getPersistenceContext().isEntryFor((Object)attachmentData)) {
                session.evict((Object)attachmentData);
            }
            throw new AttachmentDataStreamSizeMismatchException(expectedFileSize, countingInputStream.getCount());
        }
    }

    @Override
    public void replaceDataForAttachment(Attachment attachment, InputStream data) {
        AttachmentData attachmentData = null;
        try {
            attachmentData = this.getAttachmentDataForAttachment(attachment);
        }
        catch (AttachmentDataNotFoundException attachmentDataNotFoundException) {
            // empty catch block
        }
        if (attachmentData == null) {
            this.saveDataForAttachment(attachment, data);
        } else {
            attachmentData.setData(data);
            this.saveAttachmentData(attachmentData);
        }
    }

    @Override
    public boolean isAttachmentPresent(Attachment attachment) {
        return !this.getSessionFactory().getCurrentSession().createNamedQuery("confluence.ad_findAttachmentDataByAttachment").setParameter("attachment", (Object)attachment).setParameter("version", (Object)attachment.getVersion()).setMaxResults(1).list().isEmpty();
    }

    @Override
    public void moveAttachment(Attachment attachment, Attachment oldAttachment, ContentEntityObject newContent) {
    }

    private void checkAttachmentAndOriginalContentArgumentsNotNull(Attachment attachment, ContentEntityObject originalContent) {
        if (attachment == null) {
            throw new IllegalArgumentException("The attachment must not be null.");
        }
        if (originalContent == null) {
            throw new IllegalArgumentException("The content must not be null.");
        }
    }

    private void handleAttachmendDataNotFoundException(Attachment attachment, AttachmentDataNotFoundException e) {
        log.warn("Did not find data for attachment [{}].", (Object)attachment);
        log.debug(e.getMessage(), (Throwable)e);
    }

    @Override
    public AttachmentDataStorageType getStorageType() {
        return AttachmentDataStorageType.DATABASE;
    }

    @Override
    public AttachmentDataStream getDataForAttachment(Attachment attachment, AttachmentDataStreamType dataStreamType) throws AttachmentDataNotFoundException {
        return this.legacyDaoSupport().getAttachmentDataStream(attachment, dataStreamType);
    }

    @Override
    public AttachmentDataStream getDataForAttachment(Attachment attachment, AttachmentDataStreamType dataStreamType, Optional<RangeRequest> range) throws AttachmentDataNotFoundException {
        if (range != null && range.isPresent()) {
            throw new UnsupportedOperationException("This implementation has been deprecated. Use FileSystemAttachmentDataDao instead.");
        }
        return this.getDataForAttachment(attachment, dataStreamType);
    }

    @Override
    public void saveDataForAttachment(Attachment attachment, AttachmentDataStream dataStream) {
        this.legacyDaoSupport().saveDataForAttachment(attachment, dataStream);
    }

    @Override
    public void saveDataForAttachmentVersion(Attachment attachment, Attachment previousVersion, AttachmentDataStream dataStream) {
        this.legacyDaoSupport().saveDataForAttachmentVersion(attachment, previousVersion, dataStream);
    }

    @Override
    public void replaceDataForAttachment(Attachment attachment, AttachmentDataStream dataStream) {
        this.legacyDaoSupport().replaceDataForAttachment(attachment, dataStream);
    }

    private LegacyAttachmentDataDaoSupport legacyDaoSupport() {
        return new LegacyAttachmentDataDaoSupport(this);
    }
}

