/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao.hibernate;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import com.atlassian.confluence.core.persistence.hibernate.VersionedHibernateObjectDao;
import com.atlassian.confluence.impl.search.IndexerEventListener;
import com.atlassian.confluence.internal.pages.persistence.CommentDaoInternal;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.util.Assert;

public class HibernateCommentDao
extends VersionedHibernateObjectDao<Comment>
implements CommentDaoInternal {
    private static final Logger log = LoggerFactory.getLogger(HibernateCommentDao.class);
    private static final int LIMIT_ITEMS_BATCH_QUERY = 1000;
    private static final String DELETED = "deleted";
    private EventPublisher eventPublisher;

    @Override
    public Class<Comment> getPersistentClass() {
        return Comment.class;
    }

    @Override
    public Comment getById(long id) {
        return this.getByClassId(id);
    }

    @Override
    protected Comment getByClassId(long id) {
        ContentEntityObject ceo = this.hibernate().execute(session -> (ContentEntityObject)session.get(ContentEntityObject.class, (Serializable)Long.valueOf(id)));
        if (!(ceo instanceof Comment)) {
            return null;
        }
        return (Comment)ceo;
    }

    @Override
    public Iterator<Comment> getRecentlyUpdatedComments(long spaceId, int maxResults) {
        return this.hibernate().execute(session -> {
            Query queryObject = session.getNamedQuery("confluence.content_findRecentlyModifiedCommentsBySpace");
            queryObject.setParameter("spaceId", (Object)spaceId);
            queryObject.setCacheable(true);
            if (maxResults > 0) {
                queryObject.setMaxResults(maxResults);
            }
            HibernateCommentDao.applyTransactionTimeout(queryObject, this.getSessionFactory());
            return queryObject.list().iterator();
        });
    }

    @Override
    public List<Comment> getContainerComments(long containerId, Date since) {
        return this.findNamedQueryStringParams("confluence.content_findCommentsByContainerSinceDate", "containerId", containerId, "date", (Object)since, HibernateObjectDao.Cacheability.NOT_CACHEABLE);
    }

    @Override
    public List<Comment> getContainerComments(long containerId, Date since, ConfluenceUser ignoreUser) {
        if (ignoreUser == null) {
            return this.getContainerComments(containerId, since);
        }
        return this.findNamedQueryStringParams("confluence.content_findCommentsByContainerSinceDateWithoutUser", "containerId", containerId, "date", (Object)since, "ignoreUser", (Object)ignoreUser, HibernateObjectDao.Cacheability.NOT_CACHEABLE);
    }

    @Override
    public Map<Searchable, Integer> countComments(Collection<? extends Searchable> searchables) {
        Objects.requireNonNull(searchables);
        if (searchables.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Searchable> idToSearchableMap = new HashMap<Long, Searchable>();
        HashMap<Searchable, Integer> results = new HashMap<Searchable, Integer>();
        for (Searchable searchable : searchables) {
            idToSearchableMap.put(searchable.getId(), searchable);
            results.put(searchable, 0);
        }
        List hibernateResults = this.findNamedQueryStringParam("confluence.content_countCommentsForMultiple", "contentEntities", Collections2.transform(searchables, Searchable::getId));
        for (Object[] result : hibernateResults) {
            Integer numberOfComments = (Integer)result[1];
            Long contentId = (Long)result[0];
            results.put((Searchable)idToSearchableMap.get(contentId), numberOfComments);
        }
        return Map.copyOf(results);
    }

    @Override
    public int countComments(Searchable searchable) {
        Objects.requireNonNull(searchable);
        return DataAccessUtils.intResult((Collection)this.findNamedQueryStringParam("confluence.content_countCommentsForOne", "contentId", searchable.getId()));
    }

    @Override
    public int countAllCommentVersions() {
        return DataAccessUtils.intResult((Collection)this.hibernate().execute(session -> session.getNamedQuery("confluence.content_countAllComments").list()));
    }

    @Override
    public List<Comment> getContainerComments(long containerId, LimitedRequest pageRequest) {
        return this.findNamedQueryStringParams("confluence.content_findTopLevelCommentsByContainer", HibernateObjectDao.Cacheability.CACHEABLE, pageRequest, "containerId", containerId);
    }

    @Override
    public List<Comment> getChildren(Comment comment, LimitedRequest pageRequest) {
        return this.findNamedQueryStringParams("confluence.comment_getChildren", true, pageRequest, "parentId", comment.getId());
    }

    @Override
    public Map<Long, Integer> countUnresolvedComments(@NonNull Collection<Long> containerIds) {
        Assert.notNull(containerIds, (String)"containerIds should not be null");
        Assert.notEmpty(containerIds, (String)"containerIds should not be empty ");
        if (log.isDebugEnabled()) {
            log.debug("Querying database for unresolved comment count: {}", (Object)Arrays.toString(containerIds.toArray()));
        }
        HashMap result = Maps.newHashMap();
        Iterable partitionIdsList = Iterables.partition(containerIds, (int)1000);
        for (List subIdsList : partitionIdsList) {
            this.putUnresolvedCommentCountToMap(subIdsList, result);
        }
        return result;
    }

    private void putUnresolvedCommentCountToMap(List<Long> ids, Map<Long, Integer> map) {
        List queryResult = this.hibernate().execute(session -> {
            Query queryObject = session.getNamedQuery("confluence.content_unresolvedCommentCount");
            HibernateCommentDao.applyTransactionTimeout(queryObject, this.getSessionFactory());
            queryObject.setParameterList("ids", (Collection)ids);
            return queryObject.list();
        });
        if (queryResult != null) {
            for (Object obj : queryResult) {
                Object[] row = (Object[])obj;
                Long attachmentId = (Long)row[0];
                Integer unresolvedCommentCount = (Integer)row[1];
                map.put(attachmentId, unresolvedCommentCount);
            }
        }
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    protected void publishEvent(IndexerEventListener.VisitorEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publish((Object)event);
        }
    }

    @Override
    public List<Comment> scanFilteredComments(List<ContentStatus> statuses, LimitedRequest pageRequest) {
        return this.scanFilteredContents(Comment.class, statuses, pageRequest);
    }

    private static Collection<Class<? extends ContentEntityObject>> getContentEntityTypes(Collection<ContentType> contentTypes) {
        return contentTypes.stream().map(HibernateCommentDao::getEntityType).collect(Collectors.toSet());
    }

    private static Class<? extends ContentEntityObject> getEntityType(ContentType contentType) {
        if (ContentType.COMMENT.equals((Object)contentType)) {
            return Comment.class;
        }
        throw new IllegalArgumentException("Types cannot reference to any other content that pages or blog posts");
    }

    @Override
    public List<Comment> scanFilteredSpaceComments(Space space, List<ContentStatus> statuses, LimitedRequest pageRequest) {
        return this.scanFilteredContents(Comment.class, space, statuses, pageRequest);
    }

    @Override
    public long countSpaceCommentByStatuses(Space space, List<ContentStatus> contentStatuses) {
        List<String> statusNames = this.getStatusNames(contentStatuses);
        return DataAccessUtils.longResult((Collection)this.findNamedQueryStringParams("confluence.comment_countLatestSpaceCommentByStatuses", "spaceid", space.getId(), "contentStatus", statusNames));
    }

    @Override
    public long countCommentByStatuses(List<ContentStatus> contentStatuses) {
        List<String> statusNames = this.getStatusNames(contentStatuses);
        return DataAccessUtils.longResult((Collection)this.findNamedQueryStringParam("confluence.comment_countLatestCommentByStatuses", "contentStatus", statusNames));
    }
}

