/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin;

import com.atlassian.confluence.plugin.ConfluenceApplication;
import com.atlassian.confluence.plugin.PluginDirectoryProvider;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.LegacyDynamicPluginFactory;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.factories.XmlDynamicPluginFactory;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.factory.OsgiBundleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPluginFactory;
import com.atlassian.plugin.osgi.factory.RemotablePluginFactory;
import com.atlassian.plugin.osgi.internal.factory.transform.DefaultPluginTransformer;
import com.atlassian.plugin.osgi.internal.factory.transform.TransformStage;
import com.atlassian.plugin.osgi.internal.factory.transform.stage.GenerateManifestStage;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class PluginFactoriesConfiguration {
    @Resource
    private PluginDirectoryProvider bootstrapPluginDirectoryProvider;
    @Resource
    private OsgiContainerManager osgiContainerManager;
    @Resource
    private OsgiPersistentCache osgiPersistentCache;
    @Resource
    private PluginEventManager pluginEventManager;

    PluginFactoriesConfiguration() {
    }

    @Bean
    List<? extends PluginFactory> pluginFactories() {
        return List.of(this.legacyPluginFactory(), this.osgiPluginFactory(), this.osgiBundleFactory(), this.xmlDynamicPluginFactory(), this.remotablePluginFactory());
    }

    @Bean
    OsgiPluginFactory osgiPluginFactory() {
        return new OsgiPluginFactory("atlassian-plugin.xml", Set.copyOf(ConfluenceApplication.getConfluenceApplications()), this.osgiPersistentCache, this.osgiContainerManager, this.pluginEventManager, (cache, systemExports, applicationKeys, pluginDescriptorPath, osgi) -> new DefaultPluginTransformer(cache, systemExports, applicationKeys, pluginDescriptorPath, osgi, PluginFactoriesConfiguration.customTransformStages()));
    }

    private static List<TransformStage> customTransformStages() {
        ArrayList stages = DefaultPluginTransformer.getDefaultTransformStages();
        int insertI = PluginFactoriesConfiguration.indexOfType(stages, GenerateManifestStage.class);
        if (insertI == -1) {
            throw new IllegalStateException("GenerateManifestStage not found");
        }
        stages.add(insertI, context -> context.getExtraImports().removeIf(imp -> imp.startsWith("javax.annotation")));
        return stages;
    }

    private static <T> int indexOfType(List<T> list, Class<? extends T> type) {
        for (int i = 0; i < list.size(); ++i) {
            if (!type.isInstance(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Bean
    OsgiBundleFactory osgiBundleFactory() {
        return new OsgiBundleFactory(this.osgiContainerManager);
    }

    @Bean
    RemotablePluginFactory remotablePluginFactory() {
        return new RemotablePluginFactory("atlassian-plugin.xml", Set.copyOf(ConfluenceApplication.getConfluenceApplications()), this.osgiContainerManager, this.pluginEventManager);
    }

    @Bean
    LegacyDynamicPluginFactory legacyPluginFactory() {
        return new LegacyDynamicPluginFactory("atlassian-plugin.xml", this.bootstrapPluginDirectoryProvider.getPluginTempDirectory());
    }

    @Bean
    XmlDynamicPluginFactory xmlDynamicPluginFactory() {
        return new XmlDynamicPluginFactory(Set.copyOf(ConfluenceApplication.getConfluenceApplications()));
    }
}

