/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin;

import com.atlassian.confluence.impl.plugin.TransactionalPluginLoader;
import com.atlassian.confluence.impl.plugin.persistence.PluginDataDao;
import com.atlassian.confluence.plugin.BundledPluginLoaderFactory;
import com.atlassian.confluence.plugin.DatabasePluginScanner;
import com.atlassian.confluence.plugin.DirectoryScanningPluginFactory;
import com.atlassian.confluence.plugin.ExtraBundledPluginsFactory;
import com.atlassian.confluence.plugin.PluginDirectoryProvider;
import com.atlassian.confluence.plugin.PluginLoadersFactory;
import com.atlassian.confluence.plugin.RosterFilePluginLoaderFactory;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import com.atlassian.plugin.loaders.ClassPathPluginLoader;
import com.atlassian.plugin.loaders.DiscardablePluginLoader;
import com.atlassian.plugin.loaders.DynamicPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.RosterFilePluginLoader;
import com.atlassian.plugin.loaders.ScanningPluginLoader;
import com.atlassian.plugin.loaders.classloading.Scanner;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletContext;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class PluginLoadersConfiguration {
    @Resource
    private List<PluginFactory> pluginFactories;
    @Resource
    private List<String> pluginModuleXmlLocations;
    @Resource
    private PluginEventManager pluginEventManager;
    @Resource
    private TransactionalHostContextAccessor transactionalHostContextAccessor;
    @Resource
    private PluginDirectoryProvider bootstrapPluginDirectoryProvider;
    @Resource
    private PluginDataDao pluginDataDao;
    @Resource
    private ServletContext servletContext;

    PluginLoadersConfiguration() {
    }

    @Bean
    Iterable<PluginLoader> pluginLoaders() throws Exception {
        return PluginLoadersFactory.getLoaders(this.pluginModuleXmlLocations, Arrays.asList(this.bundledPluginLoader(), this.classpathPluginLoader(), this.databasePluginLoader(), this.directoryScanningPluginLoader(), this.rosterFilePluginLoader()), new ExtraBundledPluginsFactory(this.bootstrapPluginDirectoryProvider, this.pluginFactories, this.pluginEventManager));
    }

    @Bean
    ClassPathPluginLoader classpathPluginLoader() {
        return new ClassPathPluginLoader("atlassian-plugin.xml");
    }

    @Bean
    ScanningPluginLoader directoryScanningPluginLoader() {
        return new DirectoryScanningPluginFactory(this.pluginFactories, this.pluginEventManager).getObject();
    }

    @Bean
    RosterFilePluginLoader rosterFilePluginLoader() {
        return new RosterFilePluginLoaderFactory(this.pluginFactories, this.pluginEventManager).getObject();
    }

    @Bean
    TransactionalPluginLoader databasePluginLoader() {
        ScanningPluginLoader loader = new ScanningPluginLoader((Scanner)new DatabasePluginScanner(this.pluginDataDao, this.bootstrapPluginDirectoryProvider.getPluginsCacheDirectory(), this.transactionalHostContextAccessor), this.pluginFactories, this.pluginEventManager);
        return new TransactionalPluginLoader((DynamicPluginLoader)loader, (DiscardablePluginLoader)loader);
    }

    @Bean
    BundledPluginLoader bundledPluginLoader() throws Exception {
        BundledPluginLoaderFactory factory = new BundledPluginLoaderFactory(this.bootstrapPluginDirectoryProvider, this.pluginFactories, this.pluginEventManager);
        factory.setServletContext(this.servletContext);
        return factory.getObject();
    }
}

