/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.index.attachment.AttachmentTextExtractor;
import com.atlassian.confluence.plugin.module.PluginModuleFactory;
import com.atlassian.confluence.plugin.module.PluginModuleHolder;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class AttachmentTextExtractorModuleDescriptor
extends AbstractModuleDescriptor<AttachmentTextExtractor>
implements Comparable<AttachmentTextExtractorModuleDescriptor>,
PluginModuleFactory<AttachmentTextExtractor> {
    private static final Logger log = LoggerFactory.getLogger(AttachmentTextExtractorModuleDescriptor.class);
    private PluginModuleHolder<AttachmentTextExtractor> module;
    private int priority;

    public AttachmentTextExtractorModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.priority = this.determinePriority(element);
        if (this.priority <= 0) {
            log.warn("Unable to determine priority for extractor module {}", (Object)this.getCompleteKey());
            this.priority = 10;
        }
        this.module = PluginModuleHolder.getInstance(this);
    }

    private int determinePriority(Element element) {
        return Integer.parseInt(element.attributeValue("priority", "0"));
    }

    public AttachmentTextExtractor getModule() {
        return this.module.getModule();
    }

    public void enabled() {
        super.enabled();
        this.module.enabled(this.getModuleClass());
    }

    public void disabled() {
        this.module.disabled();
        super.disabled();
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(AttachmentTextExtractorModuleDescriptor other) {
        if (other.priority != this.priority) {
            return other.priority - this.priority;
        }
        return this.getCompleteKey().compareTo(other.getCompleteKey());
    }

    @Override
    public AttachmentTextExtractor createModule() {
        return (AttachmentTextExtractor)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }
}

