/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColourSchemeModuleDescriptor
extends AbstractModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(ColourSchemeModuleDescriptor.class);
    private static final Map<String, String> TRANSLATOR = Map.of("topbar", "property.style.topbarcolour", "spacename", "property.style.spacenamecolour", "headingtext", "property.style.headingtextcolour", "link", "property.style.linkcolour", "border", "property.style.bordercolour", "navbg", "property.style.navbgcolour", "navtext", "property.style.navtextcolour", "navselectedbg", "property.style.navselectedbgcolour", "navselectedtext", "property.style.navselectedtextcolour");
    private final Map<String, String> colours = new HashMap<String, String>();

    public ColourSchemeModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public Object getModule() {
        Class clazz = this.getModuleClass();
        try {
            Constructor ctor = clazz.getConstructor(Map.class);
            return ctor.newInstance(new HashMap<String, String>(this.colours));
        }
        catch (Exception e) {
            log.error("Unable to instantiate plugin colour scheme key: {} of class: {} message: {}", new Object[]{this.getCompleteKey(), ((Object)((Object)this)).getClass().getName(), e, e});
            return null;
        }
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.extractColours(element, "color");
        this.extractColours(element, "colour");
    }

    private void extractColours(Element element, String tagName) throws PluginParseException {
        for (Element colour : element.elements(tagName)) {
            String key = colour.attributeValue("key");
            String value = colour.attributeValue("value");
            if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value)) {
                throw new PluginParseException("Malformed colour module: colours must have key and value");
            }
            if (TRANSLATOR.containsKey(key)) {
                key = TRANSLATOR.get(key);
            }
            if (this.colours.containsKey(key)) {
                log.warn("Colour scheme {} contains multiple definitions for colour: {}", (Object)this.getCompleteKey(), (Object)colour.attributeValue("key"));
            }
            if (log.isDebugEnabled()) {
                log.debug("{} {}: {}", new Object[]{this.getCompleteKey(), key, value});
            }
            this.colours.put(key, value);
        }
    }
}

