/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public final class ComponentModuleDescriptor
extends AbstractModuleDescriptor
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ComponentModuleDescriptor.class);
    String alias;
    private ApplicationContext appContext;

    public ComponentModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.alias = element.attributeValue("alias");
        if (!StringUtils.isNotEmpty((CharSequence)this.alias)) {
            this.alias = this.getKey();
        }
    }

    public Object getModule() {
        throw new UnsupportedOperationException("You cannot retrieve a component instance - Spring-ified");
    }

    public void enabled() {
        super.enabled();
        DefaultListableBeanFactory beanFactory = this.getGlobalBeanFactoryUsingHacks();
        if (beanFactory != null) {
            if (beanFactory.containsBean(this.alias)) {
                throw new IllegalStateException("Can not overwrite an existing bean definition: " + this.alias);
            }
            log.debug("Creating bean definition for {} with class {}", (Object)this.alias, (Object)this.getModuleClass().getName());
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(this.getModuleClass(), 1, false);
            log.debug("Registering bean definition for {} with class {}", (Object)this.alias, (Object)this.getModuleClass().getName());
            beanFactory.registerBeanDefinition(this.alias, (BeanDefinition)rootBeanDefinition);
            if (StateAware.class.isAssignableFrom(this.getModuleClass())) {
                Object o = beanFactory.getBean(this.alias);
                StateAware sa = (StateAware)o;
                sa.enabled();
            }
        }
    }

    public void disabled() {
        DefaultListableBeanFactory beanFactory;
        if (log.isDebugEnabled()) {
            log.debug("Disabling component module {}", (Object)this.getKey());
        }
        if ((beanFactory = this.getGlobalBeanFactoryUsingHacks()) != null) {
            Object o = null;
            try {
                o = beanFactory.getBean(this.alias);
            }
            catch (BeanCreationException | NoSuchBeanDefinitionException throwable) {
                // empty catch block
            }
            if (o instanceof StateAware) {
                StateAware sa = (StateAware)o;
                sa.disabled();
            }
            log.debug("Removing bean definition for {}", (Object)this.alias);
            beanFactory.removeBeanDefinition(this.alias);
        }
        super.disabled();
    }

    private DefaultListableBeanFactory getGlobalBeanFactoryUsingHacks() {
        ApplicationContext applicationContext = this.getApplicationContextWithHack();
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
            if (configurableApplicationContext.getBeanFactory() instanceof DefaultListableBeanFactory) {
                return (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
            }
            log.error("Failed to lookup global bean factory - BeanFactory was not a ConfluenceListableBeanFactory?");
        } else {
            log.error("Failed to lookup global bean factory - ApplicationContext was not a ConfigurableApplicationContext?");
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.appContext = applicationContext;
    }

    private ApplicationContext getApplicationContextWithHack() {
        return this.appContext;
    }
}

