/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.plugin.module.PluginProvidedDecoratorModule;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DecoratorModuleDescriptor
extends AbstractModuleDescriptor<PluginProvidedDecoratorModule> {
    static final String SINGLE_PATTERN = "pattern";
    private final List<String> patterns = new ArrayList<String>();
    private String page;

    public DecoratorModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.initPageElement(element);
        this.initPatternElements(element);
    }

    private void initPageElement(Element element) {
        this.page = element.attributeValue("page");
        if (this.page == null) {
            throw new PluginParseException("No 'page' attribute specified for decorator module " + this.getName());
        }
    }

    private void initPatternElements(Element parent) {
        for (Element elem : parent.elements()) {
            if (!SINGLE_PATTERN.equals(elem.getName())) continue;
            if (!this.isSimplePattern(elem.getText())) {
                throw new PluginParseException("incorrect syntax for pattern element : " + elem.getText());
            }
            this.patterns.add(elem.getText());
        }
    }

    private boolean isSimplePattern(String pattern) {
        if (pattern == null) {
            return false;
        }
        int asteriskCount = pattern.length() - pattern.replace("*", "").length();
        if (asteriskCount > 1) {
            return false;
        }
        if (asteriskCount == 1) {
            return pattern.endsWith("*") || pattern.startsWith("*") || pattern.contains("*.");
        }
        return true;
    }

    private boolean isMatch(String pattern, String target) {
        int asteriskIndex = pattern.indexOf("*");
        if (asteriskIndex != -1) {
            String prefix = pattern.substring(0, asteriskIndex);
            String suffix = pattern.substring(asteriskIndex + 1);
            if (pattern.endsWith("*")) {
                return target.startsWith(prefix);
            }
            if (pattern.startsWith("*")) {
                return target.endsWith(suffix);
            }
            return target.endsWith(suffix) && target.startsWith(prefix);
        }
        return target.equals(pattern);
    }

    public PluginProvidedDecoratorModule getModule() {
        return new PluginProvidedDecoratorModule(){

            @Override
            public boolean matches(String path) {
                return DecoratorModuleDescriptor.this.patterns.stream().anyMatch(p -> DecoratorModuleDescriptor.this.isMatch((String)p, path));
            }

            @Override
            public String getTemplate() {
                return DecoratorModuleDescriptor.this.page;
            }

            @Override
            public String key() {
                return DecoratorModuleDescriptor.this.getCompleteKey();
            }
        };
    }
}

