/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.confluence.plugin.descriptor.AbstractFieldMappingsProviderModuleDescriptor;
import com.atlassian.confluence.plugin.module.PluginModuleFactory;
import com.atlassian.confluence.plugin.module.PluginModuleHolder;
import com.atlassian.confluence.plugins.index.api.mapping.FieldMappingsProvider;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FieldMappingsProviderModuleDescriptor
extends AbstractFieldMappingsProviderModuleDescriptor<FieldMappingsProvider>
implements PluginModuleFactory<FieldMappingsProvider> {
    private PluginModuleHolder<FieldMappingsProvider> moduleHolder;
    private Optional<Index> systemIndex;
    private Optional<Index> customIndex;

    public FieldMappingsProviderModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) {
        super.init(plugin, element);
        this.moduleHolder = PluginModuleHolder.getInstance(this);
        this.systemIndex = Optional.ofNullable(element.attributeValue("index")).map(Index::system);
        this.customIndex = Optional.ofNullable(element.attributeValue("custom-index")).map(Index::custom);
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("index") == null && element.attributeValue("custom-index") == null) {
            throw new ValidationException("There were validation errors:", Collections.singletonList("The index or custom-index is required"));
        }
    }

    @Override
    public List<Index> getIndices() {
        return Stream.of(this.systemIndex, this.customIndex).flatMap(Optional::stream).collect(Collectors.toList());
    }

    @Override
    public FieldMappingsProvider createModule() {
        this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        return (FieldMappingsProvider)ConfluencePluginUtils.instantiatePluginModule(this.plugin, this.getModuleClass());
    }

    public FieldMappingsProvider getModule() {
        return this.moduleHolder.getModule();
    }

    public void enabled() {
        super.enabled();
        this.moduleHolder.enabled(this.getModuleClass());
    }

    public void disabled() {
        this.moduleHolder.disabled();
        super.disabled();
    }
}

