/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.api.model.index.IndexRecoverer;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.confluence.plugin.module.PluginModuleFactory;
import com.atlassian.confluence.plugin.module.PluginModuleHolder;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class IndexRecovererModuleDescriptor
extends AbstractModuleDescriptor<IndexRecoverer>
implements PluginModuleFactory<IndexRecoverer> {
    private PluginModuleHolder<IndexRecoverer> moduleHolder;
    private JournalIdentifier journalId;
    private String indexDirName;
    private String indexName;

    public IndexRecovererModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.moduleHolder = PluginModuleHolder.getInstance(this);
        this.journalId = new JournalIdentifier(element.element("journal-id").getText());
        this.indexDirName = element.element("index-dir-name").getText();
        this.indexName = element.element("index-name") == null ? this.indexDirName : element.element("index-name").getText();
    }

    public IndexRecoverer getModule() {
        return this.moduleHolder.getModule();
    }

    public void enabled() {
        super.enabled();
        this.moduleHolder.enabled(this.getModuleClass());
    }

    public void disabled() {
        this.moduleHolder.disabled();
        super.disabled();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexDirName() {
        return this.indexDirName;
    }

    public JournalIdentifier getJournalId() {
        return this.journalId;
    }

    @Override
    public IndexRecoverer createModule() {
        this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        return (IndexRecoverer)ConfluencePluginUtils.instantiatePluginModule(this.plugin, this.getModuleClass());
    }
}

