/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.plugin.module.PluginModuleHolder;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LanguageModuleDescriptor
extends AbstractModuleDescriptor<Language> {
    private String encoding;
    private String language;
    private String country;
    private String variant;
    private PluginModuleHolder<Language> languageModule;

    public LanguageModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.attributeValue("language") != null) {
            this.setLanguage(element.attributeValue("language"));
        }
        if (element.attributeValue("country") != null) {
            this.setCountry(element.attributeValue("country"));
        }
        if (element.attributeValue("variant") != null) {
            this.setVariant(element.attributeValue("variant"));
        }
        if (element.attributeValue("encoding") != null) {
            this.setEncoding(element.attributeValue("encoding"));
        }
        if (element.attributeValue("language") == null || !StringUtils.isNotEmpty((CharSequence)element.attributeValue("language"))) {
            throw new PluginParseException("Module " + this.getCompleteKey() + " must define an \"language\" attribute");
        }
        this.languageModule = PluginModuleHolder.getInstance(() -> new Language(this));
    }

    public Language getModule() {
        return this.languageModule.getModule();
    }

    public void enabled() {
        super.enabled();
        this.languageModule.enabled(this.getModuleClass());
    }

    public void disabled() {
        this.languageModule.disabled();
        super.disabled();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }
}

