/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.plugin.module.PluginModuleHolder;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.servlet.simpledisplay.PathConverterManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PathConverterModuleDescriptor
extends AbstractModuleDescriptor<PathConverter> {
    private static final String DEFAULT_WEIGHT = "100";
    private PluginModuleHolder<PathConverter> moduleHolder;
    private final PathConverterManager pathConverterManager;
    private int weight;

    public PathConverterModuleDescriptor(ModuleFactory moduleFactory, PathConverterManager pathConverterManager) {
        super(moduleFactory);
        this.pathConverterManager = pathConverterManager;
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.setWeight(PathConverterModuleDescriptor.calculateWeight(element));
        this.setModuleHolder(PluginModuleHolder.getInstanceWithDefaultFactory(this));
    }

    public PathConverter getModule() {
        return this.moduleHolder.getModule();
    }

    public void enabled() {
        super.enabled();
        this.moduleHolder.enabled(this.getModuleClass());
        this.pathConverterManager.addPathConverter(this.weight, this.moduleHolder.getModule());
    }

    public void disabled() {
        if (this.moduleHolder.isEnabled()) {
            this.pathConverterManager.removePathConverter(this.moduleHolder.getModule());
        }
        this.moduleHolder.disabled();
        super.disabled();
    }

    private static int calculateWeight(Element element) {
        return Integer.parseInt(element.attributeValue("weight", DEFAULT_WEIGHT));
    }

    void setModuleHolder(PluginModuleHolder<PathConverter> moduleHolder) {
        this.moduleHolder = moduleHolder;
    }

    void setWeight(int weight) {
        this.weight = weight;
    }
}

