/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.core.PermissionOverrideExtension;
import com.atlassian.confluence.plugin.module.PluginModuleFactory;
import com.atlassian.confluence.plugin.module.PluginModuleHolder;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.api.descriptors.WeightedDescriptor;
import org.checkerframework.checker.nullness.qual.NonNull;

@ExperimentalApi
public final class PermissionOverrideExtensionDescriptor
extends AbstractModuleDescriptor<PermissionOverrideExtension>
implements WeightedDescriptor,
PluginModuleFactory<PermissionOverrideExtension> {
    private final PluginModuleHolder<PermissionOverrideExtension> holder = PluginModuleHolder.getInstance(this);
    private int weight;

    public PermissionOverrideExtensionDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = Integer.parseInt(element.attributeValue("weight"));
    }

    @Override
    public PermissionOverrideExtension createModule() {
        return this.holder.getModule();
    }

    public PermissionOverrideExtension getModule() {
        return (PermissionOverrideExtension)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public void enabled() {
        super.enabled();
        this.holder.enabled(this.getModuleClass());
    }

    public void disabled() {
        this.holder.disabled();
        super.disabled();
    }

    public int getWeight() {
        return this.weight;
    }
}

