/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.plugin.descriptor.ElementToDom4jConversionHelper;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.io.DOMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class SpringComponentModuleDescriptor
extends AbstractModuleDescriptor
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringComponentModuleDescriptor.class);
    private String alias;
    private Document document;
    private ApplicationContext appContext;

    public SpringComponentModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.alias = element.attributeValue("alias");
        if (!StringUtils.isNotEmpty((CharSequence)this.alias)) {
            this.alias = this.getKey();
        }
        DocumentFactory factory = DocumentFactory.getInstance();
        org.dom4j.Element beans = factory.createElement("beans");
        org.dom4j.Element bean = factory.createElement("bean");
        beans.add(bean);
        bean.addAttribute("id", this.alias);
        bean.addAttribute("class", element.attributeValue("class"));
        for (String attributeName : element.attributeNames()) {
            if (attributeName.equals("key") || attributeName.equals("name") || attributeName.equals("class") || attributeName.equals("alias")) continue;
            bean.addAttribute(attributeName, element.attributeValue(attributeName));
        }
        for (Element elem : element.elements()) {
            bean.add(ElementToDom4jConversionHelper.convert(factory, elem));
        }
        this.document = factory.createDocument();
        this.document.add(beans);
    }

    public Object getModule() {
        try {
            return ContainerManager.getComponent((String)this.alias);
        }
        catch (ComponentNotFoundException cnfe) {
            return null;
        }
    }

    public void enabled() {
        super.enabled();
        DefaultListableBeanFactory beanFactory = this.getGlobalBeanFactoryUsingHacks();
        if (beanFactory != null) {
            if (beanFactory.containsBean(this.alias)) {
                throw new IllegalStateException("Can not overwrite an existing bean definition: " + this.alias);
            }
            log.debug("Creating bean definition for {} with class {}", (Object)this.alias, (Object)this.getModuleClass().getName());
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
            if (this.plugin.isDynamicallyLoaded()) {
                reader.setBeanClassLoader(this.plugin.getClassLoader());
            }
            DOMWriter writer = new DOMWriter();
            try {
                reader.registerBeanDefinitions(writer.write(this.document), (Resource)new ClassPathResource("x"));
                ContainerManager.getComponent((String)this.alias);
            }
            catch (DocumentException de) {
                log.error("failed to convert Document to DOM", (Throwable)de);
            }
        }
    }

    public void disabled() {
        DefaultListableBeanFactory beanFactory = this.getGlobalBeanFactoryUsingHacks();
        if (beanFactory != null) {
            log.debug("Removing bean definition for {}", (Object)this.alias);
            beanFactory.removeBeanDefinition(this.alias);
        }
        super.disabled();
    }

    private DefaultListableBeanFactory getGlobalBeanFactoryUsingHacks() {
        ApplicationContext applicationContext = this.getApplicationContextWithHack();
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
            if (configurableApplicationContext.getBeanFactory() instanceof DefaultListableBeanFactory) {
                return (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
            }
            log.error("Failed to lookup global bean factory - BeanFactory was not a DefaultListableBeanFactory?");
        } else {
            log.error("Failed to lookup global bean factory - ApplicationContext was not a ConfigurableApplicationContext?");
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    private ApplicationContext getApplicationContextWithHack() {
        return this.appContext;
    }
}

