/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.event.events.plugin.StrutsStateChangeEvent;
import com.atlassian.confluence.impl.struts.MultipartUploadConfigurator;
import com.atlassian.confluence.impl.struts.OgnlAllowListConfigurator;
import com.atlassian.confluence.impl.struts.PluginModuleXmlConfigurationProvider;
import com.atlassian.confluence.plugin.descriptor.ElementToDom4jConversionHelper;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.struts2.config.ConfigurationManager;
import org.apache.struts2.config.ContainerProvider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Node;
import org.dom4j.io.DOMWriter;
import org.dom4j.tree.DefaultDocument;

public class StrutsModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private final EventPublisher eventPublisher;
    private final ConfigurationManager configurationManager;
    private PluginModuleXmlConfigurationProvider configProvider;
    private ModuleCompleteKey completeKey;
    private Set<Pattern> multipartAllowlistPatterns;
    private final MultipartUploadConfigurator multipartUploadConfigurator;
    private final OgnlAllowListConfigurator ognlAllowListConfigurator;
    private Set<String> ognlAllowlistClasses;
    private Set<String> ognlAllowlistPackages;

    public StrutsModuleDescriptor(ModuleFactory moduleFactory, EventPublisher eventPublisher, ConfigurationManager configurationManager, MultipartUploadConfigurator multipartUploadConfigurator, OgnlAllowListConfigurator ognlAllowListConfigurator) {
        super(moduleFactory);
        this.eventPublisher = eventPublisher;
        this.configurationManager = configurationManager;
        this.multipartUploadConfigurator = multipartUploadConfigurator;
        this.ognlAllowListConfigurator = ognlAllowListConfigurator;
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.completeKey = new ModuleCompleteKey(this.getCompleteKey());
        this.multipartAllowlistPatterns = StrutsModuleDescriptor.parseChildrenPatterns(element.element("multipart-upload-allowlist"));
        this.ognlAllowlistClasses = this.readOgnlAllowList(element, "struts.allowlist.classes");
        this.ognlAllowlistPackages = this.readOgnlAllowList(element, "struts.allowlist.packages");
        this.configProvider = new PluginModuleXmlConfigurationProvider(StrutsModuleDescriptor.convertElement(element), plugin, this::disabled);
    }

    private Set<String> readOgnlAllowList(Element strutsElem, String constantName) {
        Element ognlConstantElement = strutsElem.elements().stream().filter(e -> "constant".equals(e.getName()) && constantName.equals(e.attributeValue("name"))).findFirst().orElse(null);
        if (ognlConstantElement == null) {
            return null;
        }
        if (ognlConstantElement.attributeValue("value") != null) {
            return Arrays.stream(ognlConstantElement.attributeValue("value").split(",")).map(String::trim).collect(Collectors.toSet());
        }
        return null;
    }

    static org.w3c.dom.Document convertElement(Element element) {
        DocumentFactory factory = DocumentFactory.getInstance();
        org.dom4j.Element clonedElement = ElementToDom4jConversionHelper.convert(factory, element);
        clonedElement.elements().stream().filter(child -> !child.getName().equals("package")).forEach(Node::detach);
        try {
            return new DOMWriter().write((Document)new DefaultDocument(clonedElement));
        }
        catch (DocumentException e) {
            throw new PluginParseException((Throwable)e);
        }
    }

    public static Set<Pattern> parseChildrenPatterns(Element element) {
        if (element == null) {
            return null;
        }
        List regexExpElements = element.elements("regex");
        HashSet<Pattern> set = new HashSet<Pattern>();
        for (Element regExpEl : regexExpElements) {
            String regExpText = regExpEl.getText();
            try {
                set.add(Pattern.compile(regExpText));
            }
            catch (PatternSyntaxException e) {
                throw new PluginParseException("Multipart allowlist RegEx entry could not be parsed: " + regExpText, (Throwable)e);
            }
        }
        return set;
    }

    public void enabled() {
        if (this.isEnabled()) {
            return;
        }
        super.enabled();
        if (this.multipartAllowlistPatterns != null) {
            this.multipartUploadConfigurator.registerPluginPatterns(this.completeKey, this.multipartAllowlistPatterns);
        }
        if (this.ognlAllowlistClasses != null) {
            try {
                this.ognlAllowListConfigurator.registerClassAllowListForPlugin(this.plugin, this.completeKey, this.ognlAllowlistClasses);
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Failed to load a class defined in atlassian-plugin.xml for plugin module %s.".formatted(this.completeKey), (Throwable)e);
            }
        }
        if (this.ognlAllowlistPackages != null) {
            String pluginSymbolicName;
            try {
                pluginSymbolicName = StrutsModuleDescriptor.extractSymbolicNameIfP2(this.plugin.getClassLoader().toString());
            }
            catch (IllegalArgumentException e) {
                throw new PluginParseException("Cannot allowlist package if plugin %s is not backed by an OSGi bundle - disabling module %s".formatted(this.getPluginKey(), this.completeKey), (Throwable)e);
            }
            this.ognlAllowListConfigurator.registerPackageAllowListForPlugin(this.completeKey, pluginSymbolicName, this.ognlAllowlistPackages);
        }
        this.configurationManager.addContainerProvider((ContainerProvider)Objects.requireNonNull(this.configProvider));
        this.eventPublisher.publish((Object)new StrutsStateChangeEvent((Object)this));
    }

    public void disabled() {
        if (!this.isEnabled()) {
            return;
        }
        super.disabled();
        if (this.multipartAllowlistPatterns != null) {
            this.multipartUploadConfigurator.clearPluginPatterns(this.completeKey);
        }
        if (this.ognlAllowlistClasses != null) {
            this.ognlAllowListConfigurator.clearClassAllowListForPlugin(this.completeKey);
        }
        if (this.ognlAllowlistPackages != null) {
            this.ognlAllowListConfigurator.clearPackageAllowListForPlugin(this.completeKey);
        }
        this.configurationManager.removeContainerProvider((ContainerProvider)this.configProvider);
        this.eventPublisher.publish((Object)new StrutsStateChangeEvent((Object)this));
    }

    public Void getModule() {
        return null;
    }

    private static String extractSymbolicNameIfP2(String classLoader) {
        String tempName = classLoader.substring(classLoader.indexOf("bundle=") + "bundle=".length());
        List<String> parsedParts = Arrays.stream(tempName.split("\\s+")).toList();
        if (parsedParts.size() != 2 || parsedParts.get(0).isEmpty()) {
            throw new IllegalArgumentException();
        }
        return parsedParts.get(0);
    }
}

