/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.event.events.plugin.XStreamStateChangeEvent;
import com.atlassian.confluence.impl.xstream.security.XStreamSecurityConfigurator;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XStreamSecurityModuleDescriptor
extends AbstractModuleDescriptor {
    private final XStreamSecurityConfigurator xStreamSecurityConfigurator;
    private final EventPublisher eventPublisher;
    private Element element;
    private String pluginKey;
    private static final Logger logger = LoggerFactory.getLogger(XStreamSecurityModuleDescriptor.class);

    public XStreamSecurityModuleDescriptor(ModuleFactory moduleFactory, XStreamSecurityConfigurator xStreamSecurityConfigurator, EventPublisher eventPublisher) {
        super(moduleFactory);
        this.xStreamSecurityConfigurator = xStreamSecurityConfigurator;
        this.eventPublisher = eventPublisher;
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.pluginKey = plugin.getKey();
        this.element = element;
    }

    public void enabled() {
        super.enabled();
        if (!this.element.elements("regex").isEmpty() || !this.element.elements("wildcard").isEmpty()) {
            logger.warn("Element '{}' contains 'regex' or 'wildcard' and is no longer supported with Confluence XStream.", (Object)this.element.getName());
        }
        List typeElements = this.element.elements("type");
        Set<String> types = this.getChildren(typeElements);
        this.xStreamSecurityConfigurator.addAllowTypes(this.pluginKey, types);
        this.eventPublisher.publish((Object)new XStreamStateChangeEvent((Object)this));
    }

    public void disabled() {
        super.disabled();
        this.xStreamSecurityConfigurator.clearPluginSecurityData(this.pluginKey);
        this.eventPublisher.publish((Object)new XStreamStateChangeEvent((Object)this));
    }

    public Object getModule() {
        return null;
    }

    private Set<String> getChildren(List<Element> elements) {
        return elements.stream().map(Element::getText).collect(Collectors.toSet());
    }
}

