/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor.web;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.util.collections.LazyMap;
import com.atlassian.user.User;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

@ParametersAreNonnullByDefault
public class DefaultWebInterfaceContext
implements WebInterfaceContext {
    private final LazyMap<String, Object> contextMap = new LazyMap();

    public static DefaultWebInterfaceContext copyOf(WebInterfaceContext webInterfaceContext) {
        return DefaultWebInterfaceContext.createFrom(webInterfaceContext);
    }

    public static DefaultWebInterfaceContext createFrom(Map<String, ?> contextMap) {
        DefaultWebInterfaceContext copy = new DefaultWebInterfaceContext();
        copy.setParameters(contextMap);
        return copy;
    }

    @Override
    public @Nullable ConfluenceUser getCurrentUser() {
        User user = (User)this.contextMap.get((Object)"user");
        return FindUserHelper.getUser(user);
    }

    public void setCurrentUser(@Nullable ConfluenceUser user) {
        this.setParameter("user", user);
    }

    @Override
    public @Nullable AbstractPage getPage() {
        return (AbstractPage)this.contextMap.get((Object)"page");
    }

    @Override
    @Deprecated
    public @Nullable Draft getDraft() {
        return (Draft)this.contextMap.get((Object)"draft");
    }

    @Override
    @Deprecated
    public @Nullable ContentEntityObject getContentDraft() {
        ContentEntityObject draft = (ContentEntityObject)this.contextMap.get((Object)"contentDraft");
        if (draft == null) {
            draft = this.getDraft();
        }
        return draft;
    }

    public void setPage(@Nullable AbstractPage page) {
        this.setParameter("page", page);
    }

    @Override
    public @Nullable Space getSpace() {
        return (Space)this.contextMap.get((Object)"space");
    }

    @Override
    public Optional<Long> getSpaceId() {
        return Optional.ofNullable((Long)this.contextMap.get((Object)"spaceid"));
    }

    @Override
    public @Nullable String getSpaceKey() {
        return (String)this.contextMap.get((Object)"spacekey");
    }

    public void setSpace(@Nullable Space space) {
        this.setParameter("space", space);
        if (space != null) {
            this.setParameter("spaceid", space.getId());
        }
    }

    @Override
    public @Nullable Comment getComment() {
        return (Comment)this.contextMap.get((Object)"comment");
    }

    public void setComment(Comment comment) {
        this.setParameter("comment", comment);
    }

    @Override
    public @Nullable DisplayableLabel getLabel() {
        return (DisplayableLabel)this.contextMap.get((Object)"label");
    }

    public void setLabel(DisplayableLabel label) {
        this.setParameter("label", label);
    }

    @Override
    public @Nullable Attachment getAttachment() {
        return (Attachment)this.contextMap.get((Object)"attachment");
    }

    public void setAttachment(Attachment attachment) {
        this.setParameter("attachment", attachment);
    }

    @Override
    public @Nullable PersonalInformation getPersonalInformation() {
        return (PersonalInformation)this.contextMap.get((Object)"userinfo");
    }

    public void setPersonalInformation(PersonalInformation personalInformation) {
        this.setParameter("userinfo", personalInformation);
    }

    @Override
    public @Nullable Object getParameter(String key) {
        return this.contextMap.get((Object)key);
    }

    @Override
    public boolean hasParameter(String key) {
        return this.contextMap.containsKey((Object)key);
    }

    public void setParameter(String key, @Nullable Object value) {
        this.contextMap.put((Object)key, value);
    }

    public void setParameters(Map<String, ?> parameters) {
        if (parameters instanceof LazyMap) {
            LazyMap lazyMap = (LazyMap)parameters;
            this.contextMap.putAll(lazyMap);
        } else if (parameters instanceof DefaultWebInterfaceContext) {
            DefaultWebInterfaceContext webInterfaceContext = (DefaultWebInterfaceContext)parameters;
            this.contextMap.putAll(webInterfaceContext.contextMap);
        } else {
            this.contextMap.putAll(parameters);
        }
    }

    public void withLazyParameter(String key, Supplier<?> supplier) {
        this.contextMap.lazyPut((Object)key, supplier);
    }

    @Override
    public Map<String, Object> toMap() {
        return LazyMap.copyOf(this.contextMap);
    }

    @Override
    public @Nullable ConfluenceUser getTargetedUser() {
        return (ConfluenceUser)this.contextMap.get((Object)"targetUser");
    }

    public void setTargetedUser(@Nullable ConfluenceUser user) {
        this.setParameter("targetUser", user);
    }

    @Deprecated
    public void setIsEditPageRestricted(boolean restricted) {
        this.setParameter("editPageRestricted", restricted);
    }

    @Override
    @Deprecated
    public boolean isEditPageRestricted() {
        if (!this.hasParameter("editPageRestricted")) {
            return false;
        }
        return (Boolean)this.contextMap.get((Object)"editPageRestricted");
    }

    @Override
    public @Nullable AbstractPage getParentPage() {
        return (AbstractPage)this.contextMap.get((Object)"parentPage");
    }

    public DefaultWebInterfaceContext putAllMissing(WebInterfaceContext source) {
        if (source instanceof DefaultWebInterfaceContext) {
            DefaultWebInterfaceContext context = (DefaultWebInterfaceContext)source;
            this.contextMap.putAllIfAbsent(context.contextMap);
        } else {
            for (Map.Entry entry : source.entrySet()) {
                if (this.hasParameter((String)entry.getKey())) continue;
                this.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        return this;
    }
}

