/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor.web.urlreadingconditions;

import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DarkFeatureEnabledUrlReadingCondition
implements UrlReadingCondition {
    private final DarkFeaturesManager darkFeaturesManager;
    private String darkFeatureKey;

    public DarkFeatureEnabledUrlReadingCondition(DarkFeaturesManager darkFeaturesManager) {
        this.darkFeaturesManager = darkFeaturesManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String key = params.get("key");
        if (key == null || StringUtils.isBlank((CharSequence)key)) {
            throw new PluginParseException("Dark feature key must not be empty");
        }
        this.darkFeatureKey = key;
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.darkFeaturesManager.getDarkFeatures().isFeatureEnabled(this.darkFeatureKey)) {
            urlBuilder.addToQueryString(this.darkFeatureKey, String.valueOf(true));
        }
    }

    public boolean shouldDisplay(QueryParams params) {
        return Boolean.parseBoolean(params.get(this.darkFeatureKey));
    }
}

