/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor.web.urlreadingconditions;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import java.util.Map;

public class SystemAdministratorUrlReadingCondition
implements UrlReadingCondition {
    private static final String SYSTEM_ADMINISTRATOR_QUERY_PARAM = "isSystemAdministrator";
    private final PermissionManager permissionManager;

    public SystemAdministratorUrlReadingCondition(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isSystemAdministrator()) {
            urlBuilder.addToQueryString(SYSTEM_ADMINISTRATOR_QUERY_PARAM, String.valueOf(true));
        }
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        return Boolean.parseBoolean(queryParams.get(SYSTEM_ADMINISTRATOR_QUERY_PARAM));
    }

    private boolean isSystemAdministrator() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

