/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor.web.urlreadingconditions;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import java.util.Map;

public class UserLoggedInUrlReadingCondition
implements UrlReadingCondition {
    private static final String USER_LOGGED_IN_QUERY_PARAM = "user-logged-in";

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isUserLoggedIn()) {
            urlBuilder.addToQueryString(USER_LOGGED_IN_QUERY_PARAM, String.valueOf(true));
        }
    }

    public boolean shouldDisplay(QueryParams params) {
        return Boolean.parseBoolean(params.get(USER_LOGGED_IN_QUERY_PARAM));
    }

    private boolean isUserLoggedIn() {
        return !AuthenticatedUserThreadLocal.isAnonymousUser();
    }
}

