/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.persistence;

import com.atlassian.confluence.core.NotExportable;
import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;
import org.hibernate.annotations.GenericGenerator;

@MappedSuperclass
public abstract class AbstractPluginData
implements NotExportable {
    @Id
    @Column(name="PLUGINDATAID", updatable=false)
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    @GeneratedValue(generator="resettable-hilo-v5")
    private long id;
    @Column(name="PLUGINKEY", nullable=false, unique=true, length=255)
    private String key;
    @Column(name="FILENAME", nullable=false, unique=true, length=255)
    private String fileName;
    @Column(name="LASTMODDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModificationDate;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(Date lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    public String toString() {
        return "PluginData: { fileName: " + this.fileName + ", lastModificationDate: " + String.valueOf(this.lastModificationDate) + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPluginData that = (AbstractPluginData)o;
        if (this.id != that.id) {
            return false;
        }
        if (!Objects.equals(this.fileName, that.fileName)) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        return AbstractPluginData.customDateEquals(this.lastModificationDate, that.lastModificationDate);
    }

    private static boolean customDateEquals(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 != null && date2 != null) {
            return date1.getTime() == date2.getTime();
        }
        return false;
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + (this.lastModificationDate != null ? this.lastModificationDate.hashCode() : 0);
        return result;
    }
}

