/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.servlet.filter;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.impl.security.access.AnnotatedPermitChecker;
import com.atlassian.plugin.servlet.filter.DelegatingPluginFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessCheckPluginDelegateFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AccessCheckPluginDelegateFilter.class);
    private final DelegatingPluginFilter delegatingPluginFilter;
    private final AnnotatedPermitChecker annotatedPermitChecker;

    public AccessCheckPluginDelegateFilter(DelegatingPluginFilter delegatingPluginFilter, AnnotatedPermitChecker annotatedPermitChecker) {
        this.delegatingPluginFilter = Objects.requireNonNull(delegatingPluginFilter);
        this.annotatedPermitChecker = Objects.requireNonNull(annotatedPermitChecker);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.annotatedPermitChecker.verifyIsPermitted(this.delegatingPluginFilter.getDelegatingFilter().getClass(), "doFilter", ServletRequest.class, ServletResponse.class, FilterChain.class)) {
            this.delegatingPluginFilter.doFilter(request, response, chain);
        } else {
            logger.debug("Access check is failed. Skipping filter {}", (Object)this.delegatingPluginFilter.getDelegatingFilter().getClass());
            chain.doFilter(request, response);
        }
    }

    @VisibleForTesting
    public DelegatingPluginFilter getDelegatingPluginFilter() {
        return this.delegatingPluginFilter;
    }
}

