/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.servlet.filter;

import com.atlassian.confluence.impl.security.access.AnnotatedPermitChecker;
import com.atlassian.confluence.plugin.servlet.filter.AccessCheckPluginDelegateFilter;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.servlet.filter.DelegatingPluginFilter;
import com.atlassian.plugin.servlet.filter.FilterDispatcherCondition;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedServletModuleManagerWrapper
implements ServletModuleManager {
    private static final Logger logger = LoggerFactory.getLogger(EnhancedServletModuleManagerWrapper.class);
    final ServletModuleManager delegate;
    private final AnnotatedPermitChecker annotatedPermitChecker;

    public EnhancedServletModuleManagerWrapper(AnnotatedPermitChecker annotatedPermitChecker, ServletModuleManager delegate) {
        this.delegate = delegate;
        this.annotatedPermitChecker = annotatedPermitChecker;
    }

    Iterable<Filter> enhanceWithAccessCheck(Iterable<Filter> originalFilters) {
        logger.debug("Enhance plugin filters with access check");
        ArrayList<Filter> enhancedFilterList = new ArrayList<Filter>();
        for (Filter filter : originalFilters) {
            enhancedFilterList.add(new AccessCheckPluginDelegateFilter((DelegatingPluginFilter)filter, this.annotatedPermitChecker));
        }
        return enhancedFilterList;
    }

    public void addServletModule(ServletModuleDescriptor descriptor) {
        this.delegate.addServletModule(descriptor);
    }

    public HttpServlet getServlet(String path, ServletConfig servletConfig) throws ServletException {
        return this.delegate.getServlet(path, servletConfig);
    }

    public void removeServletModule(ServletModuleDescriptor descriptor) {
        this.delegate.removeServletModule(descriptor);
    }

    public void addFilterModule(ServletFilterModuleDescriptor descriptor) {
        this.delegate.addFilterModule(descriptor);
    }

    public Iterable<Filter> getFilters(FilterLocation location, String pathInfo, FilterConfig filterConfig, FilterDispatcherCondition condition) throws ServletException {
        Iterable filters = this.delegate.getFilters(location, pathInfo, filterConfig, condition);
        return this.enhanceWithAccessCheck(filters);
    }

    public Iterable<Filter> getFilters(FilterLocation location, String pathInfo, FilterConfig filterConfig, DispatcherType dispatcher) {
        Iterable filters = this.delegate.getFilters(location, pathInfo, filterConfig, dispatcher);
        return this.enhanceWithAccessCheck(filters);
    }

    public void removeFilterModule(ServletFilterModuleDescriptor descriptor) {
        this.delegate.removeFilterModule(descriptor);
    }

    public void addServlet(Plugin plugin, String servletName, String className) {
        this.delegate.addServlet(plugin, servletName, className);
    }

    public void addServlet(Plugin plugin, String servletName, HttpServlet servlet, ServletContext servletContext) {
        this.delegate.addServlet(plugin, servletName, servlet, servletContext);
    }
}

