/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.servlet.filter;

import com.atlassian.confluence.impl.security.access.AnnotatedPermitChecker;
import com.atlassian.confluence.plugin.servlet.filter.EnhancedServletModuleManagerWrapper;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.filter.DelegatingPluginFilter;
import com.atlassian.plugin.servlet.filter.FilterDispatcherCondition;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import java.util.List;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JohnsonedEnhancedServletModuleManagerWrapper
extends EnhancedServletModuleManagerWrapper {
    private static final Logger log = LoggerFactory.getLogger(JohnsonedEnhancedServletModuleManagerWrapper.class);
    private static final List<String> allowedFilters = List.of("com.atlassian.plugins.authentication.sso.web.filter.AbstractJohnsonAwareFilter", "com.atlassian.plugins.authentication.sso.web.filter.authentication.ConfluenceLanguageSupportFilter", "com.atlassian.plugins.rest.v2.servlet.RestSeraphFilter", "com.atlassian.plugins.rest.v2.servlet.RestServletUtilsUpdaterFilter", "com.atlassian.plugins.rest.v2.servlet.RestServletFilterModuleContainerServlet", "com.atlassian.plugins.rest.v2.servlet.RestDelegatingServletFilter");

    public JohnsonedEnhancedServletModuleManagerWrapper(AnnotatedPermitChecker annotatedPermitChecker, ServletModuleManager delegate) {
        super(annotatedPermitChecker, delegate);
    }

    @Override
    public Iterable<Filter> getFilters(FilterLocation location, String pathInfo, FilterConfig filterConfig, FilterDispatcherCondition condition) throws ServletException {
        List<Filter> filters = StreamSupport.stream(this.delegate.getFilters(location, pathInfo, filterConfig, condition).spliterator(), false).filter(JohnsonedEnhancedServletModuleManagerWrapper::isWhitelisted).toList();
        return this.enhanceWithAccessCheck(filters);
    }

    @Override
    public Iterable<Filter> getFilters(FilterLocation location, String pathInfo, FilterConfig filterConfig, DispatcherType dispatcher) {
        List<Filter> filters = StreamSupport.stream(this.delegate.getFilters(location, pathInfo, filterConfig, dispatcher).spliterator(), false).filter(JohnsonedEnhancedServletModuleManagerWrapper::isWhitelisted).toList();
        return this.enhanceWithAccessCheck(filters);
    }

    private static boolean isWhitelisted(Filter filter) {
        try {
            while (filter instanceof DelegatingPluginFilter) {
                filter = ((DelegatingPluginFilter)filter).getDelegatingFilter();
            }
            for (Class filterClass = filter.getClass(); filterClass != null; filterClass = filterClass.getSuperclass()) {
                String className = filterClass.getName();
                if (!allowedFilters.contains(className)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.debug("Error processing filter {}", (Object)filter, (Object)e);
        }
        return false;
    }
}

