/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.servlet.filter;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.impl.security.access.AnnotatedPermitChecker;
import com.atlassian.confluence.impl.security.access.NoCheckAnnotatedPermitChecker;
import com.atlassian.confluence.plugin.servlet.filter.EnhancedServletModuleManagerWrapper;
import com.atlassian.confluence.plugin.servlet.filter.JohnsonedEnhancedServletModuleManagerWrapper;
import com.atlassian.confluence.setup.SetupContext;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.johnson.plugin.servlet.filter.JohnsonServletFilterModuleContainerFilter;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.LazyReference;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ServletFilterModuleContainerFilter
extends JohnsonServletFilterModuleContainerFilter {
    private static final String DISABLE_ALL_FILTERS_FLAG = "confluence.johnson.plugin.filters.override.disabled";
    private static final Logger LOG = LoggerFactory.getLogger(ServletFilterModuleContainerFilter.class);
    private final Supplier<ServletModuleManager> moduleManagerReference = MemoizingComponentReference.containerComponent("servletModuleManager");
    @VisibleForTesting
    ServletRequest currentRequest;

    protected ServletModuleManager getServletModuleManager() {
        if (SetupContext.isAvailable()) {
            return (ServletModuleManager)SetupContext.get().getBean("setupServletModuleManager", ServletModuleManager.class);
        }
        if (!ContainerManager.isContainerSetup()) {
            return null;
        }
        try {
            AnnotatedPermitChecker annotatedPermitChecker = (AnnotatedPermitChecker)this.currentRequest.getAttribute("3af_annotated_permitted_checker");
            if (annotatedPermitChecker == null) {
                annotatedPermitChecker = new NoCheckAnnotatedPermitChecker();
            }
            if (this.shouldDisableAllPluginFiltersIfJohnsoned()) {
                return new EnhancedServletModuleManagerWrapper(annotatedPermitChecker, this.moduleManagerReference.get());
            }
            if (super.bypassFilters()) {
                return new JohnsonedEnhancedServletModuleManagerWrapper(annotatedPermitChecker, this.moduleManagerReference.get());
            }
            return new EnhancedServletModuleManagerWrapper(annotatedPermitChecker, this.moduleManagerReference.get());
        }
        catch (LazyReference.InitializationException | IllegalStateException e) {
            LOG.debug("Application context has not been properly initialized", e);
            LOG.error("Application context has not been properly initialized: ", (Object)e.getMessage());
            return null;
        }
    }

    protected boolean bypassFilters() {
        return this.shouldDisableAllPluginFiltersIfJohnsoned() ? super.bypassFilters() : false;
    }

    private boolean shouldDisableAllPluginFiltersIfJohnsoned() {
        return Boolean.getBoolean(DISABLE_ALL_FILTERS_FLAG);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.currentRequest = request;
        super.doFilter(request, response, chain);
    }
}

