/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.webresource;

import com.atlassian.confluence.themes.ColorSchemeBean;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.webresource.api.transformer.TransformerParameters;
import com.atlassian.webresource.spi.transformer.TransformerUrlBuilder;
import com.atlassian.webresource.spi.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.webresource.spi.transformer.WebResourceTransformerFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ColoursWebResourceTransformer
implements WebResourceTransformerFactory {
    private final ColourSchemeManager colourSchemeManager;

    public ColoursWebResourceTransformer(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters transformerParameters) {
        return urlBuilder -> {};
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return (transformableResource, params) -> new DownloadableResource(){

            public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
                return false;
            }

            public void serveResource(HttpServletRequest request, HttpServletResponse response) {
            }

            public void streamResource(OutputStream out) {
                VelocityContext context = new VelocityContext();
                ColourScheme colourScheme = ColoursWebResourceTransformer.this.colourSchemeManager.getDefaultColourScheme();
                context.put("colorScheme", (Object)new ColorSchemeBean(colourScheme));
                String transformableResourceStream = VelocityUtils.getRenderedTemplate(transformableResource.location().getLocation(), (Context)context);
                try {
                    transformableResourceStream = transformableResourceStream.replace("##.*", "").replaceAll("\\s+", " ");
                    out.write(transformableResourceStream.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public String getContentType() {
                return "text/css";
            }
        };
    }
}

