/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.webresource;

import com.atlassian.confluence.cache.ThreadLocalCacheAccessor;
import com.atlassian.confluence.plugin.webresource.Counter;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DefaultCounter
implements Counter {
    private static final ThreadLocalCacheAccessor<Keys, Integer> CACHE_ACCESSOR = ThreadLocalCacheAccessor.newInstance();
    private final PluginSettings globalSettings;
    private final String key;

    public DefaultCounter(String key, PluginSettingsFactory pluginSettingsFactory) {
        this.key = key;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public int getCounter() {
        return CACHE_ACCESSOR.getOrCompute(Keys.KEY, () -> Objects.requireNonNullElse(this.globalSettings.get(this.key), 1));
    }

    @Override
    public void updateCounter() {
        int newVal = this.getCounter() + 1;
        this.globalSettings.put(this.key, (Object)newVal);
        CACHE_ACCESSOR.put(Keys.KEY, newVal);
    }

    private static enum Keys {
        KEY;

    }
}

