/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.webresource;

import com.atlassian.confluence.plugin.webresource.CssResourceCounterManager;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Objects;

public class DefaultCssResourceCounterManager
implements CssResourceCounterManager {
    private final PluginSettingsFactory settingsFactory;

    public DefaultCssResourceCounterManager(PluginSettingsFactory pluginSettingsFactory) {
        this.settingsFactory = pluginSettingsFactory;
    }

    @Override
    public void invalidateGlobalCssResourceCounter() {
        int old = this.getGlobalCssResourceCounter();
        this.setGlobalCssResourceCounter(old + 1);
    }

    @Override
    public void invalidateSpaceCssResourceCounter(String spaceKey) {
        int old = this.getSpaceCssResourceCounter(spaceKey);
        this.setSpaceCssResourceCounter(spaceKey, old + 1);
    }

    @Override
    public int getGlobalCssResourceCounter() {
        Integer globalCssResourceCounter = (Integer)this.settingsFactory.createGlobalSettings().get("atlassian.confluence.css.resource.counter");
        return Objects.requireNonNullElse(globalCssResourceCounter, 1);
    }

    @Override
    public int getSpaceCssResourceCounter(String spaceKey) {
        Integer spaceCssResourceCounter = (Integer)this.settingsFactory.createSettingsForKey(spaceKey).get("atlassian.confluence.css.resource.counter");
        return Objects.requireNonNullElse(spaceCssResourceCounter, 1);
    }

    private void setGlobalCssResourceCounter(Integer globalCssResourceCounter) {
        this.settingsFactory.createGlobalSettings().put("atlassian.confluence.css.resource.counter", (Object)globalCssResourceCounter);
    }

    private void setSpaceCssResourceCounter(String spaceKey, Integer spaceCssResourceCounter) {
        this.settingsFactory.createSettingsForKey(spaceKey).put("atlassian.confluence.css.resource.counter", (Object)spaceCssResourceCounter);
    }
}

