/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.webresource;

import com.atlassian.confluence.plugin.webresource.WebResourceDispatcher;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.servlet.util.LastModifiedHandler;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.support.http.Request;
import com.atlassian.plugin.webresource.impl.support.http.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebResourceDispatcher
implements WebResourceDispatcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebResourceDispatcher.class);
    private final Globals globals;

    public DefaultWebResourceDispatcher(Globals globals) {
        this.globals = globals;
    }

    @Override
    public void dispatch(HttpServletRequest httpServletRequest, String path, HttpServletResponse httpServletResponse) {
        LastModifiedHandler lastModifiedHandler;
        Request request = new Request(this.globals, httpServletRequest, GeneralUtil.getCharacterEncoding());
        Response response = new Response(request, httpServletResponse);
        log.debug("WRM serving plugin resource before dispatch with request URL {} and original response status code {}", (Object)request.getPath(), (Object)response.getStatus());
        if (request.isCacheable() && response.checkRequestHelper(lastModifiedHandler = this.getLastModifiedHandler(httpServletRequest))) {
            return;
        }
        this.globals.getRouter().dispatch(this.createRequest(path, request.getParams()), response);
    }

    protected Request createRequest(String path, Map<String, String> params) {
        return new Request(this.globals, path, params);
    }

    @Override
    public boolean canDispatch(String path) {
        return this.globals.getRouter().canDispatch(path);
    }

    private LastModifiedHandler getLastModifiedHandler(HttpServletRequest originalRequest) {
        Date lastModifiedDate = null;
        try {
            long ifModifiedSinceValue = originalRequest.getDateHeader("If-Modified-Since");
            if (ifModifiedSinceValue >= 0L) {
                lastModifiedDate = new Date(ifModifiedSinceValue);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return lastModifiedDate != null ? new LastModifiedHandler(lastModifiedDate) : new LastModifiedHandler();
    }
}

