/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.webresource;

import com.atlassian.confluence.event.events.plugin.PluginEvent;
import com.atlassian.confluence.event.events.plugin.PluginFrameworkStartedEvent;
import com.atlassian.confluence.plugin.webresource.ConfluenceResourceBatchingConfiguration;
import com.atlassian.confluence.plugin.webresource.Counter;
import com.atlassian.event.api.EventListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperBatchInvalidatorListener {
    private static final Logger log = LoggerFactory.getLogger(SuperBatchInvalidatorListener.class);
    private ConfluenceResourceBatchingConfiguration resourceBatchingConfiguration;
    private Counter superbatchResourceCounter;

    @EventListener
    public void handleEvent(PluginFrameworkStartedEvent event) {
        this.superbatchResourceCounter.updateCounter();
    }

    @EventListener
    public void handleEvent(PluginEvent event) {
        if (this.shouldInvalidateSuperBatch(event)) {
            this.superbatchResourceCounter.updateCounter();
        }
    }

    private boolean shouldInvalidateSuperBatch(PluginEvent pluginEvent) {
        List<String> keys = this.resourceBatchingConfiguration.getSuperBatchModuleCompleteKeys();
        for (String key : keys) {
            if (!key.startsWith(pluginEvent.getPluginKey() + ":")) continue;
            log.debug("Invalidate super batch resource counter by {}", (Object)key);
            return true;
        }
        return false;
    }

    public void setResourceBatchingConfiguration(ConfluenceResourceBatchingConfiguration resourceBatchingConfiguration) {
        this.resourceBatchingConfiguration = resourceBatchingConfiguration;
    }

    public void setSuperbatchResourceCounter(Counter superbatchResourceCounter) {
        this.superbatchResourceCounter = superbatchResourceCounter;
    }
}

