/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.index.api.mapping;

import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.StoredFieldDescriptor;
import com.atlassian.confluence.plugins.index.api.StringFieldDescriptor;
import com.atlassian.confluence.plugins.index.api.mapping.AbstractFieldMapping;
import com.atlassian.confluence.plugins.index.api.mapping.FieldMappingVisitor;

public class StringFieldMapping
extends AbstractFieldMapping {
    private final boolean asLowercase;
    private final boolean withLowercase;

    protected StringFieldMapping(Builder builder) {
        super(builder);
        this.asLowercase = builder.asLowercase;
        this.withLowercase = builder.withLowercase;
    }

    public FieldDescriptor createField(String value) {
        return this.isIndexed() ? new StringFieldDescriptor(this, value) : new StoredFieldDescriptor(this, value);
    }

    public <T> T accept(FieldMappingVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean isAsLowercase() {
        return this.asLowercase;
    }

    public boolean isWithLowercase() {
        return this.withLowercase;
    }

    public static class Builder
    extends AbstractFieldMapping.Builder {
        private boolean asLowercase;
        private boolean withLowercase;

        public Builder(String name) {
            super(name);
        }

        @Override
        public Builder store(boolean stored) {
            super.store(stored);
            return this;
        }

        @Override
        public Builder index(boolean indexed) {
            super.index(indexed);
            return this;
        }

        public Builder asLowercase(boolean asLowercase) {
            this.asLowercase = asLowercase;
            return this;
        }

        public Builder withLowercase(boolean withLowercase) {
            this.withLowercase = withLowercase;
            return this;
        }

        @Override
        public StringFieldMapping build() {
            return new StringFieldMapping(this);
        }
    }
}

