/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.radeox.macros;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.struts.ConfluenceVelocityManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceActionForDecorating;
import com.atlassian.confluence.velocity.ContextUtils;
import com.atlassian.spring.container.ContainerManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ActionInvocation;
import org.apache.velocity.context.Context;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MacroUtils {
    private MacroUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static Map<String, Object> defaultVelocityContext() {
        return MacroUtils.defaultVelocityContext(null);
    }

    public static Map<String, Object> defaultVelocityContext(@Nullable Space space) {
        return ContextUtils.toMap((Context)MacroUtils.createDefaultVelocityContext(space));
    }

    public static Map<String, Object> requiredVelocityContext(List<String> requiredKeys) {
        if (CollectionUtils.isEmpty(requiredKeys)) {
            return Collections.emptyMap();
        }
        return MacroUtils.defaultVelocityContext().entrySet().stream().filter(e -> requiredKeys.contains(e.getKey()) && e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Context createDefaultVelocityContext() {
        return MacroUtils.createDefaultVelocityContext(null);
    }

    private static Context createDefaultVelocityContext(@Nullable Space space) {
        Context ctx = ConfluenceVelocityManager.getConfluenceVelocityContext();
        ctx.put("action", (Object)MacroUtils.getConfluenceActionSupport(space));
        return ctx;
    }

    public static ConfluenceActionSupport newConfluenceActionSupport() {
        return MacroUtils.getConfluenceActionSupport(null);
    }

    private static ConfluenceActionSupport getConfluenceActionSupport(@Nullable Space space) {
        return (ConfluenceActionSupport)Optional.ofNullable(ActionContext.getContext()).map(ActionContext::getActionInvocation).map(ActionInvocation::getAction).orElseGet(() -> {
            ConfluenceActionSupport action = space == null ? new ConfluenceActionSupport() : new SpaceActionForDecorating(space);
            ContainerManager.autowireComponent((Object)action);
            return action;
        });
    }
}

