/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc;

import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.rpc.RpcServer;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.event.api.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcConfigurationChangeListener {
    private static final Logger log = LoggerFactory.getLogger(RpcConfigurationChangeListener.class);
    private RpcServer soapServer;
    private RpcServer xmlRpcServer;

    @EventListener
    public void handleEvent(ClusterEventWrapper event) {
        ClusterEvent wrapped = event.getEvent();
        if (wrapped instanceof GlobalSettingsChangedEvent) {
            this.handleEvent((GlobalSettingsChangedEvent)wrapped);
        }
    }

    @EventListener
    public void handleEvent(GlobalSettingsChangedEvent settingsEvent) {
        Settings oldSettings = settingsEvent.getOldSettings();
        Settings newSettings = settingsEvent.getNewSettings();
        if (oldSettings.isAllowRemoteApi() != newSettings.isAllowRemoteApi() || oldSettings.isAllowRemoteApiAnonymous() != newSettings.isAllowRemoteApiAnonymous() || !settingsEvent.getOldDomainName().equals(settingsEvent.getNewDomainName())) {
            log.info("RPC configuration has changed. Triggering an RPC subsystem reload");
            this.soapServer.reloadConfiguration();
            this.xmlRpcServer.reloadConfiguration();
        }
    }

    public void setAxisSoapServer(RpcServer soapServer) {
        this.soapServer = soapServer;
    }

    public void setGlueSoapServer(RpcServer soapServer) {
        this.soapServer = soapServer;
    }

    public void setXmlRpcServer(RpcServer xmlRpcServer) {
        this.xmlRpcServer = xmlRpcServer;
    }
}

