/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rss;

import com.atlassian.confluence.util.UrlUtils;
import org.apache.commons.lang3.StringUtils;

public class FeedProperties {
    private static final String EMAIL_PATTERN_STRING = "([\\w\\-%+.]+@[\\w\\-%.]+\\.\\p{Alpha}+)";
    private final String title;
    private final String description;
    private final boolean showContent;
    private final boolean publicFeed;
    public static final String DEFAULT_FEED_TITLE = "Confluence RSS Feed";

    public FeedProperties(String title, String description, boolean showContent, boolean publicFeed) {
        if (StringUtils.isBlank((CharSequence)description)) {
            throw new IllegalArgumentException("Description is required.");
        }
        this.title = StringUtils.isNotBlank((CharSequence)title) ? this.cleanUpTitle(title) : DEFAULT_FEED_TITLE;
        this.description = description;
        this.showContent = showContent;
        this.publicFeed = publicFeed;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isShowContent() {
        return this.showContent;
    }

    public boolean isPublicFeed() {
        return this.publicFeed;
    }

    private String cleanUpTitle(String title) {
        return FeedProperties.removeEmailsFromString(UrlUtils.removeUrlsFromString(title));
    }

    private static String removeEmailsFromString(String text) {
        return text != null ? text.replaceAll(EMAIL_PATTERN_STRING, "") : "";
    }
}

