/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search;

import com.atlassian.confluence.api.service.index.ReIndexOption;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.ReIndexSupport;
import com.atlassian.confluence.search.ReIndexUtils;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.util.JvmSystemResources;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.unit.DataSize;

public class AttachmentOnlyReIndexSupport
implements ReIndexSupport<Attachment> {
    private static final Logger log = LoggerFactory.getLogger(AttachmentOnlyReIndexSupport.class);

    @Override
    public Class<Attachment> getEntityClass() {
        return Attachment.class;
    }

    @Override
    public SearchQuery getDeleteQuery() {
        return ReIndexUtils.ATTACHMENT_ONLY_QUERY;
    }

    @Override
    public SearchQuery getDeleteQuery(Optional<String> spaceKey) {
        return spaceKey.isPresent() ? ReIndexUtils.ATTACHMENT_ONLY_IN_SPACE_QUERY.apply(spaceKey.get()) : ReIndexUtils.ATTACHMENT_ONLY_QUERY;
    }

    @Override
    public Integer getThreadCount(JvmSystemResources jvmRuntime) {
        int availableProcessors = jvmRuntime.getAvailableProcessors();
        DataSize freeMemory = jvmRuntime.getFreeMemory();
        DataSize availableMemoryRequiredPerThread = DataSize.ofMegabytes((long)Integer.getInteger("reindex.attachments.freeMbPerThread", 500).intValue());
        int threadLimitByAvailableMemory = (int)(freeMemory.toBytes() / availableMemoryRequiredPerThread.toBytes());
        int defaultThreadCount = Math.max(4, Math.min(availableProcessors, threadLimitByAvailableMemory));
        log.info("Available CPUs: {}, available memory: {}, required available memory per attachment reindex thread: {}, attachment reindex threads limited to {}", new Object[]{availableProcessors, FileUtils.byteCountToDisplaySize((long)freeMemory.toBytes()), FileUtils.byteCountToDisplaySize((long)availableMemoryRequiredPerThread.toBytes()), defaultThreadCount});
        return Integer.getInteger("reindex.attachments.thread.count", defaultThreadCount);
    }

    public String toString() {
        return ReIndexOption.ATTACHMENT_ONLY.name();
    }
}

