/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search;

import com.atlassian.confluence.api.service.index.ReIndexOption;
import com.atlassian.confluence.core.persistence.SearchableDao;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.search.ReIndexSupport;
import com.atlassian.confluence.search.ReIndexUtils;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.util.JvmSystemResources;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class ContentOnlyReIndexSupport
implements ReIndexSupport<Object> {
    @Override
    public List<HibernateHandle> getHandles(SearchableDao dao, Optional<String> spaceKey) {
        return dao.getLatestSearchableHandlesGroupedByType(spaceKey).stream().filter(x -> {
            Iterator iterator = x.iterator();
            return iterator.hasNext() && this.getClassFilter().test(((HibernateHandle)iterator.next()).getClassName());
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public SearchQuery getDeleteQuery() {
        return ReIndexUtils.CONTENT_ONLY_QUERY;
    }

    @Override
    public SearchQuery getDeleteQuery(Optional<String> spaceKey) {
        return spaceKey.isPresent() ? ReIndexUtils.CONTENT_ONLY_IN_SPACE_QUERY.apply(spaceKey.get()) : ReIndexUtils.CONTENT_ONLY_QUERY;
    }

    @Override
    public Integer getThreadCount(JvmSystemResources jvmRuntime) {
        return (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{Integer.getInteger("reindex.thread.count"), Integer.getInteger("index.queue.thread.count"), jvmRuntime.getAvailableProcessors()});
    }

    @Override
    public Predicate<String> getClassFilter() {
        return ReIndexUtils.CONTENT_CLASSES;
    }

    public String toString() {
        return ReIndexOption.CONTENT_ONLY.name();
    }
}

