/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search;

import com.atlassian.confluence.core.persistence.SearchableDao;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.search.AttachmentOnlyReIndexSupport;
import com.atlassian.confluence.search.ContentOnlyReIndexSupport;
import com.atlassian.confluence.search.ReIndexSupport;
import com.atlassian.confluence.search.UserOnlyReIndexSupport;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.util.JvmSystemResources;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public enum ReIndexOption implements ReIndexSupport<Object>
{
    CONTENT_ONLY(new ContentOnlyReIndexSupport()),
    ATTACHMENT_ONLY(new AttachmentOnlyReIndexSupport()),
    USER_ONLY(new UserOnlyReIndexSupport());

    private final ReIndexSupport delegate;

    private ReIndexOption(ReIndexSupport delegate) {
        this.delegate = delegate;
    }

    @Override
    public SearchQuery getDeleteQuery() {
        return this.delegate.getDeleteQuery();
    }

    @Override
    public SearchQuery getDeleteQuery(Optional<String> spaceKey) {
        return this.delegate.getDeleteQuery(spaceKey);
    }

    public Integer getThreadCount() {
        return this.delegate.getThreadCount(JvmSystemResources.getRuntime());
    }

    @Override
    public Integer getThreadCount(JvmSystemResources jvmRuntime) {
        return this.delegate.getThreadCount(jvmRuntime);
    }

    @Override
    public Predicate<String> getClassFilter() {
        return this.delegate.getClassFilter();
    }

    @Override
    public List<HibernateHandle> getHandles(SearchableDao dao, Optional<String> spaceKey) {
        return this.delegate.getHandles(dao, spaceKey);
    }

    @Override
    public List<HibernateHandle> getHandles(SearchableDao dao) {
        return this.delegate.getHandles(dao, Optional.empty());
    }

    public static boolean isFullReindex(Set<ReIndexOption> options) {
        return options == null || options.containsAll(ReIndexOption.fullReindex()) && ReIndexOption.fullReindex().containsAll(options);
    }

    public static EnumSet<ReIndexOption> fullReindex() {
        return ReIndexOption.fullReindex(true);
    }

    public static EnumSet<ReIndexOption> fullReindex(boolean reindexingSite) {
        return reindexingSite ? EnumSet.of(CONTENT_ONLY, ATTACHMENT_ONLY, USER_ONLY) : EnumSet.of(CONTENT_ONLY, ATTACHMENT_ONLY);
    }

    public static EnumSet<ReIndexOption> deserialise(Collection<String> options, boolean reindexingSite) {
        if (options.isEmpty()) {
            return ReIndexOption.fullReindex(reindexingSite);
        }
        return options.stream().filter(StringUtils::isNotBlank).map(option -> {
            try {
                return ReIndexOption.valueOf(option);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(ReIndexOption.class)));
    }
}

